/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.ParseException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.atom.AtomEndpoint;
import org.apache.camel.component.atom.AtomPollingConsumer;
import org.apache.camel.component.atom.AtomUtils;
import org.apache.camel.component.atom.EntryFilter;
import org.apache.camel.component.atom.UpdatedDateFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomEntryPollingConsumer
extends AtomPollingConsumer {
    private Document<Feed> document;
    private int entryIndex;
    private EntryFilter entryFilter;
    private List<Entry> list;

    public AtomEntryPollingConsumer(AtomEndpoint endpoint, Processor processor, boolean filter, Date lastUpdate) {
        super(endpoint, processor);
        if (filter) {
            this.entryFilter = new UpdatedDateFilter(lastUpdate);
        }
    }

    @Override
    public void poll() throws Exception {
        this.getDocument();
        Feed feed = (Feed)this.document.getRoot();
        while (this.hasNextEntry()) {
            Entry entry = this.list.get(this.entryIndex--);
            boolean valid = true;
            if (this.entryFilter != null) {
                valid = this.entryFilter.isValidEntry(this.endpoint, this.document, entry);
            }
            if (!valid) continue;
            Exchange exchange = this.endpoint.createExchange(feed, entry);
            this.getProcessor().process(exchange);
            return;
        }
        this.document = null;
    }

    private Document<Feed> getDocument() throws IOException, ParseException {
        if (this.document == null) {
            this.document = AtomUtils.parseDocument(this.endpoint.getAtomUri());
            this.list = ((Feed)this.document.getRoot()).getEntries();
            this.entryIndex = this.list.size() - 1;
        }
        return this.document;
    }

    private boolean hasNextEntry() {
        return this.entryIndex >= 0;
    }
}

