/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.ha;

import io.atomix.Atomix;
import io.atomix.AtomixClient;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atomix.client.AtomixClientConfiguration;
import org.apache.camel.component.atomix.client.AtomixClientHelper;
import org.apache.camel.component.atomix.ha.AtomixClusterView;
import org.apache.camel.ha.CamelClusterService;
import org.apache.camel.impl.ha.AbstractCamelClusterService;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtomixClusterClientService
extends AbstractCamelClusterService<AtomixClusterView> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomixClusterClientService.class);
    private AtomixClientConfiguration configuration;
    private AtomixClient atomix;

    public AtomixClusterClientService() {
        this.configuration = new AtomixClientConfiguration();
    }

    public AtomixClusterClientService(CamelContext camelContext, AtomixClientConfiguration configuration) {
        super(null, camelContext);
        this.configuration = configuration.copy();
    }

    public AtomixClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AtomixClientConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public List<Address> getNodes() {
        return this.configuration.getNodes();
    }

    public void setNodes(List<Address> nodes) {
        this.configuration.setNodes(nodes);
    }

    public void setNodes(String nodes) {
        this.configuration.setNodes(nodes);
    }

    public Class<? extends Transport> getTransport() {
        return this.configuration.getTransport();
    }

    public void setTransport(Class<? extends Transport> transport) {
        this.configuration.setTransport(transport);
    }

    public AtomixClient getAtomix() {
        return (AtomixClient)this.configuration.getAtomix();
    }

    public void setAtomix(AtomixClient atomix) {
        this.configuration.setAtomix(atomix);
    }

    public String getConfigurationUri() {
        return this.configuration.getConfigurationUri();
    }

    public void setConfigurationUri(String configurationUri) {
        this.configuration.setConfigurationUri(configurationUri);
    }

    public boolean isEphemeral() {
        return this.configuration.isEphemeral();
    }

    public void setEphemeral(boolean ephemeral) {
        this.configuration.setEphemeral(ephemeral);
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.atomix != null) {
            LOGGER.debug("Shutdown atomix client {}", (Object)this.atomix);
            this.atomix.close().join();
        }
    }

    protected AtomixClusterView createView(String namespace) throws Exception {
        return new AtomixClusterView((CamelClusterService)this, namespace, (Atomix)this.getOrCreateClient(), this.configuration);
    }

    private AtomixClient getOrCreateClient() throws Exception {
        if (this.atomix == null) {
            ObjectHelper.notNull((Object)this.getCamelContext(), (String)"Camel Context");
            ObjectHelper.notNull((Object)this.configuration, (String)"Atomix Node Configuration");
            if (ObjectHelper.isEmpty(this.configuration.getNodes())) {
                throw new IllegalArgumentException("Atomix nodes should not be empty");
            }
            this.atomix = AtomixClientHelper.createClient(this.getCamelContext(), this.configuration);
            LOGGER.debug("Connect to cluster nodes: {}", this.configuration.getNodes());
            this.atomix.connect(this.configuration.getNodes()).join();
            LOGGER.debug("Connect to cluster done");
        }
        return this.atomix;
    }
}

