/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.queue;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.collections.DistributedQueue;
import io.atomix.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.atomix.client.AbstractAtomixClientConsumer;
import org.apache.camel.component.atomix.client.queue.AtomixQueueEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AtomixQueueConsumer
extends AbstractAtomixClientConsumer<AtomixQueueEndpoint> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomixQueueConsumer.class);
    private final List<Listener<DistributedQueue.ValueEvent<Object>>> listeners = new ArrayList<Listener<DistributedQueue.ValueEvent<Object>>>();
    private final String resourceName;
    private final String resultHeader;
    private DistributedQueue<Object> queue;

    public AtomixQueueConsumer(AtomixQueueEndpoint endpoint, Processor processor, String resourceName) {
        super(endpoint, processor);
        this.resourceName = resourceName;
        this.resultHeader = endpoint.getConfiguration().getResultHeader();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.queue = (DistributedQueue)((AtomixQueueEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getQueue(this.resourceName, new Resource.Config(((AtomixQueueEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(this.resourceName)), new Resource.Options(((AtomixQueueEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(this.resourceName))).join();
        LOGGER.debug("Subscribe to events for queue: {}", (Object)this.resourceName);
        this.listeners.add((Listener<DistributedQueue.ValueEvent<Object>>)this.queue.onAdd(this::onEvent).join());
        this.listeners.add((Listener<DistributedQueue.ValueEvent<Object>>)this.queue.onRemove(this::onEvent).join());
    }

    protected void doStop() throws Exception {
        this.listeners.forEach(Listener::close);
        super.doStart();
    }

    private void onEvent(DistributedQueue.ValueEvent<Object> event) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("CamelAtomixEventType", (Object)event.type());
        if (this.resultHeader == null) {
            exchange.getIn().setBody(event.value());
        } else {
            exchange.getIn().setHeader(this.resultHeader, event.value());
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }
}

