/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client;

import io.atomix.Atomix;
import io.atomix.AtomixClient;
import io.atomix.catalyst.transport.Address;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atomix.AtomixConfiguration;
import org.apache.camel.component.atomix.client.AtomixClientConfiguration;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.IntrospectionSupport;

public abstract class AbstractAtomixClientComponent<C extends AtomixClientConfiguration>
extends DefaultComponent {
    protected AbstractAtomixClientComponent() {
    }

    protected AbstractAtomixClientComponent(CamelContext camelContext) {
        super(camelContext);
    }

    public AtomixClient getAtomix() {
        return (AtomixClient)((AtomixConfiguration)this.getComponentConfiguration()).getAtomix();
    }

    public void setAtomix(AtomixClient client) {
        ((AtomixConfiguration)this.getComponentConfiguration()).setAtomix((Atomix)client);
    }

    public List<Address> getNodes() {
        return ((AtomixConfiguration)this.getComponentConfiguration()).getNodes();
    }

    public void setNodes(List<Address> nodes) {
        ((AtomixConfiguration)this.getComponentConfiguration()).setNodes(nodes);
    }

    public void setNodes(String nodes) {
        ((AtomixConfiguration)this.getComponentConfiguration()).setNodes(nodes);
    }

    public String getConfigurationUri() {
        return ((AtomixConfiguration)this.getComponentConfiguration()).getConfigurationUri();
    }

    public void setConfigurationUri(String configurationUri) {
        ((AtomixConfiguration)this.getComponentConfiguration()).setConfigurationUri(configurationUri);
    }

    protected C setConfigurationProperties(C configuration, Map<String, Object> parameters) throws Exception {
        Map configs = IntrospectionSupport.extractProperties(parameters, (String)"resource.config.");
        for (Map.Entry entry : configs.entrySet()) {
            String ref = (String)entry.getValue();
            if (!EndpointHelper.isReferenceParameter((String)ref)) {
                throw new IllegalArgumentException("The option resource.config." + ref + " should be a reference");
            }
            ((AtomixConfiguration)configuration).addResourceConfig((String)entry.getKey(), (Properties)EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)ref, Properties.class));
        }
        Map options = IntrospectionSupport.extractProperties(parameters, (String)"resource.options.");
        for (Map.Entry entry : options.entrySet()) {
            String ref = (String)entry.getValue();
            if (!EndpointHelper.isReferenceParameter((String)ref)) {
                throw new IllegalArgumentException("The option resource.options." + ref + " should be a reference");
            }
            ((AtomixConfiguration)configuration).addResourceOption((String)entry.getKey(), (Properties)EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)ref, Properties.class));
        }
        this.setProperties(configuration, parameters);
        return configuration;
    }

    protected abstract C getComponentConfiguration();
}

