/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.messaging;

import io.atomix.group.DistributedGroup;
import io.atomix.group.GroupMember;
import io.atomix.group.messaging.MessageProducer;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Message;
import org.apache.camel.component.atomix.client.AbstractAtomixClientProducer;
import org.apache.camel.component.atomix.client.messaging.AtomixMessaging;
import org.apache.camel.component.atomix.client.messaging.AtomixMessagingConfiguration;
import org.apache.camel.component.atomix.client.messaging.AtomixMessagingEndpoint;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.util.ObjectHelper;

public final class AtomixMessagingProducer
extends AbstractAtomixClientProducer<AtomixMessagingEndpoint, DistributedGroup> {
    private final AtomixMessagingConfiguration configuration;

    protected AtomixMessagingProducer(AtomixMessagingEndpoint endpoint) {
        super(endpoint, endpoint.getConfiguration().getDefaultAction().name());
        this.configuration = endpoint.getConfiguration();
    }

    @InvokeOnHeader(value="DIRECT")
    void onDirect(Message message, AsyncCallback callback) throws Exception {
        Object value = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        String memberName = (String)message.getHeader("CamelAtomixMemberName", this.configuration::getMemberName, String.class);
        String channelName = (String)message.getHeader("CamelAtomixChannelName", this.configuration::getChannelName, String.class);
        ObjectHelper.notNull((Object)memberName, (String)"CamelAtomixMemberName");
        ObjectHelper.notNull((Object)channelName, (String)"CamelAtomixChannelName");
        ObjectHelper.notNull((Object)value, (String)"CamelAtomixResourceValue");
        DistributedGroup group = (DistributedGroup)this.getResource(message);
        GroupMember member = group.member(memberName);
        MessageProducer producer = member.messaging().producer(channelName, AtomixMessaging.OPTIONS_DIRECT);
        producer.send(value).thenAccept(result -> this.processResult(message, callback, result));
    }

    @InvokeOnHeader(value="BROADCAST")
    void onBroadcast(Message message, AsyncCallback callback) throws Exception {
        Object value = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        String channelName = (String)message.getHeader("CamelAtomixChannelName", this.configuration::getChannelName, String.class);
        AtomixMessaging.BroadcastType type = (AtomixMessaging.BroadcastType)((Object)message.getHeader("CamelAtomixBroadcastType", this.configuration::getBroadcastType, AtomixMessaging.BroadcastType.class));
        ObjectHelper.notNull((Object)channelName, (String)"CamelAtomixChannelName");
        ObjectHelper.notNull((Object)value, (String)"CamelAtomixResourceValue");
        MessageProducer.Options options = type == AtomixMessaging.BroadcastType.RANDOM ? AtomixMessaging.OPTIONS_BROADCAST_RANDOM : AtomixMessaging.OPTIONS_BROADCAST;
        DistributedGroup group = (DistributedGroup)this.getResource(message);
        MessageProducer producer = group.messaging().producer(channelName, options);
        producer.send(value).thenRun(() -> this.processResult(message, callback, null));
    }

    @Override
    protected String getResourceName(Message message) {
        return (String)message.getHeader("CamelAtomixResourceName", ((AtomixMessagingEndpoint)((Object)this.getAtomixEndpoint()))::getResourceName, String.class);
    }

    @Override
    protected DistributedGroup createResource(String resourceName) {
        return (DistributedGroup)((AtomixMessagingEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getGroup(resourceName, new DistributedGroup.Config(((AtomixMessagingEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(resourceName)), new DistributedGroup.Options(((AtomixMessagingEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(resourceName))).join();
    }
}

