/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.queue;

import io.atomix.collections.DistributedQueue;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Message;
import org.apache.camel.component.atomix.client.AbstractAtomixClientProducer;
import org.apache.camel.component.atomix.client.queue.AtomixQueueConfiguration;
import org.apache.camel.component.atomix.client.queue.AtomixQueueEndpoint;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.util.ObjectHelper;

public final class AtomixQueueProducer
extends AbstractAtomixClientProducer<AtomixQueueEndpoint, DistributedQueue> {
    private final AtomixQueueConfiguration configuration;

    protected AtomixQueueProducer(AtomixQueueEndpoint endpoint) {
        super(endpoint, endpoint.getConfiguration().getDefaultAction().name());
        this.configuration = endpoint.getConfiguration();
    }

    @InvokeOnHeader(value="ADD")
    void onAdd(Message message, AsyncCallback callback) {
        DistributedQueue queue = (DistributedQueue)this.getResource(message);
        Object val = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)val, (String)"CamelAtomixResourceValue");
        queue.add(val).thenAccept(result -> this.processResult(message, callback, result));
    }

    @InvokeOnHeader(value="OFFER")
    void onOffer(Message message, AsyncCallback callback) {
        DistributedQueue queue = (DistributedQueue)this.getResource(message);
        Object val = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)val, (String)"CamelAtomixResourceValue");
        queue.offer(val).thenAccept(result -> this.processResult(message, callback, result));
    }

    @InvokeOnHeader(value="PEEK")
    void onPeek(Message message, AsyncCallback callback) {
        DistributedQueue queue = (DistributedQueue)this.getResource(message);
        queue.peek().thenAccept(result -> this.processResult(message, callback, result));
    }

    @InvokeOnHeader(value="POLL")
    void onPoll(Message message, AsyncCallback callback) {
        DistributedQueue queue = (DistributedQueue)this.getResource(message);
        queue.poll().thenAccept(result -> this.processResult(message, callback, result));
    }

    @InvokeOnHeader(value="CLEAR")
    void onClear(Message message, AsyncCallback callback) {
        DistributedQueue queue = (DistributedQueue)this.getResource(message);
        queue.clear().thenAccept(result -> this.processResult(message, callback, result));
    }

    @InvokeOnHeader(value="CONTAINS")
    void onContains(Message message, AsyncCallback callback) {
        DistributedQueue queue = (DistributedQueue)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        Object value = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)value, (String)"CamelAtomixResourceValue");
        if (consistency != null) {
            queue.contains(value, consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            queue.contains(value).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="IS_EMPTY")
    void onIsEmpty(Message message, AsyncCallback callback) {
        DistributedQueue queue = (DistributedQueue)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            queue.isEmpty(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            queue.isEmpty().thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="REMOVE")
    void onRemove(Message message, AsyncCallback callback) {
        DistributedQueue queue = (DistributedQueue)this.getResource(message);
        Object value = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        if (value == null) {
            queue.remove().thenAccept(result -> this.processResult(message, callback, result));
        } else {
            queue.remove(value).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="SIZE")
    void onSize(Message message, AsyncCallback callback) {
        DistributedQueue queue = (DistributedQueue)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            queue.size(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            queue.size().thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @Override
    protected String getResourceName(Message message) {
        return (String)message.getHeader("CamelAtomixResourceName", ((AtomixQueueEndpoint)((Object)this.getAtomixEndpoint()))::getResourceName, String.class);
    }

    @Override
    protected DistributedQueue<Object> createResource(String resourceName) {
        return (DistributedQueue)((AtomixQueueEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getQueue(resourceName, new Resource.Config(((AtomixQueueEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(resourceName)), new Resource.Options(((AtomixQueueEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(resourceName))).join();
    }
}

