/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.queue;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class AtomixQueueEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":resourceName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "atomix-queue".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "resourceName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(17);
        props.add("exchangePattern");
        props.add("ephemeral");
        props.add("resourceName");
        props.add("resourceConfigs");
        props.add("resultHeader");
        props.add("configurationUri");
        props.add("defaultResourceOptions");
        props.add("resourceOptions");
        props.add("lazyStartProducer");
        props.add("defaultAction");
        props.add("nodes");
        props.add("bridgeErrorHandler");
        props.add("defaultResourceConfig");
        props.add("transportClassName");
        props.add("atomix");
        props.add("exceptionHandler");
        props.add("readConsistency");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

