/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client;

import org.apache.camel.spi.Metadata;

public final class AtomixClientConstants {
    public static final String SCHEME_MAP = "atomix-map";
    public static final String SCHEME_MESSAGING = "atomix-messaging";
    public static final String SCHEME_MULTIMAP = "atomix-multimap";
    public static final String SCHEME_QUEUE = "atomix-queue";
    public static final String SCHEME_SET = "atomix-set";
    public static final String SCHEME_VALUE = "atomix-value";
    @Metadata(label="producer", description="The name of the resource", javaType="String")
    public static final String RESOURCE_NAME = "CamelAtomixResourceName";
    public static final String RESOURCE_ACTION = "CamelAtomixResourceAction";
    @Metadata(label="producer", description="The action to perform", javaType="org.apache.camel.component.atomix.client.map.AtomixMap.Action", applicableFor={"atomix-map"})
    public static final String RESOURCE_ACTION_MAP = "CamelAtomixResourceAction";
    @Metadata(label="producer", description="The action to perform", javaType="org.apache.camel.component.atomix.client.messaging.AtomixMessaging.Action", applicableFor={"atomix-messaging"})
    public static final String RESOURCE_ACTION_MESSAGING = "CamelAtomixResourceAction";
    @Metadata(label="producer", description="The action to perform", javaType="org.apache.camel.component.atomix.client.multimap.AtomixMultiMap.Action", applicableFor={"atomix-multimap"})
    public static final String RESOURCE_ACTION_MULTIMAP = "CamelAtomixResourceAction";
    @Metadata(label="producer", description="The action to perform", javaType="org.apache.camel.component.atomix.client.queue.AtomixQueue.Action", applicableFor={"atomix-queue"})
    public static final String RESOURCE_ACTION_QUEUE = "CamelAtomixResourceAction";
    @Metadata(label="producer", description="The action to perform", javaType="org.apache.camel.component.atomix.client.set.AtomixSet.Action", applicableFor={"atomix-set"})
    public static final String RESOURCE_ACTION_SET = "CamelAtomixResourceAction";
    @Metadata(label="producer", description="The action to perform", javaType="org.apache.camel.component.atomix.client.value.AtomixValue.Action", applicableFor={"atomix-value"})
    public static final String RESOURCE_ACTION_VALUE = "CamelAtomixResourceAction";
    @Metadata(description="The key to operate on", javaType="Object", applicableFor={"atomix-map", "atomix-multimap"})
    public static final String RESOURCE_KEY = "CamelAtomixResourceKey";
    @Metadata(label="producer", description="The value, if missing In Body is used", javaType="Object")
    public static final String RESOURCE_VALUE = "CamelAtomixResourceValue";
    @Metadata(label="producer", description="The default value of the resource", javaType="Object", applicableFor={"atomix-map"})
    public static final String RESOURCE_DEFAULT_VALUE = "CamelAtomixResourceDefaultValue";
    @Metadata(description="The old value", javaType="Object", applicableFor={"atomix-map", "atomix-value"})
    public static final String RESOURCE_OLD_VALUE = "CamelAtomixResourceOldValue";
    @Metadata(label="producer", description="Flag indicating that the resource action has result to provide in the message", javaType="boolean")
    public static final String RESOURCE_ACTION_HAS_RESULT = "CamelAtomixResourceActionHasResult";
    @Metadata(label="producer", description="The time to live of the entry", javaType="String / long", applicableFor={"atomix-map", "atomix-multimap", "atomix-set", "atomix-value"})
    public static final String RESOURCE_TTL = "CamelAtomixResourceTTL";
    @Metadata(label="producer", description="The read consistency level", javaType="io.atomix.resource.ReadConsistency", applicableFor={"atomix-map", "atomix-multimap", "atomix-queue", "atomix-set", "atomix-value"})
    public static final String RESOURCE_READ_CONSISTENCY = "CamelAtomixResourceReadConsistency";
    @Metadata(label="consumer", description="The type of event received", javaType="io.atomix.resource.Resource.EventType", applicableFor={"atomix-map", "atomix-queue", "atomix-set", "atomix-value"})
    public static final String EVENT_TYPE = "CamelAtomixEventType";
    @Metadata(label="consumer", description="The id of the message", javaType="long", applicableFor={"atomix-messaging"})
    public static final String MESSAGE_ID = "CamelAtomixEventType";
    @Metadata(label="producer", description="The Atomix Group member name", javaType="String", applicableFor={"atomix-messaging"})
    public static final String MEMBER_NAME = "CamelAtomixMemberName";
    @Metadata(label="producer", description="The messaging channel name", javaType="String", applicableFor={"atomix-messaging"})
    public static final String CHANNEL_NAME = "CamelAtomixChannelName";
    @Metadata(label="producer", description="The broadcast type", javaType="org.apache.camel.component.atomix.client.messaging.AtomixMessaging.BroadcastType", applicableFor={"atomix-messaging"})
    public static final String BROADCAST_TYPE = "CamelAtomixBroadcastType";

    private AtomixClientConstants() {
    }
}

