/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.set;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.collections.DistributedSet;
import io.atomix.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.atomix.client.AbstractAtomixClientConsumer;
import org.apache.camel.component.atomix.client.set.AtomixSetEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtomixSetConsumer
extends AbstractAtomixClientConsumer<AtomixSetEndpoint> {
    private static final Logger LOG = LoggerFactory.getLogger(AtomixSetConsumer.class);
    private final List<Listener<DistributedSet.ValueEvent<Object>>> listeners = new ArrayList<Listener<DistributedSet.ValueEvent<Object>>>();
    private final String resourceName;
    private final String resultHeader;
    private DistributedSet<Object> set;

    public AtomixSetConsumer(AtomixSetEndpoint endpoint, Processor processor, String resourceName) {
        super(endpoint, processor);
        this.resourceName = resourceName;
        this.resultHeader = endpoint.getConfiguration().getResultHeader();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.set = (DistributedSet)((AtomixSetEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getSet(this.resourceName, new Resource.Config(((AtomixSetEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(this.resourceName)), new Resource.Options(((AtomixSetEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(this.resourceName))).join();
        LOG.debug("Subscribe to events for set: {}", (Object)this.resourceName);
        this.listeners.add((Listener<DistributedSet.ValueEvent<Object>>)((Listener)this.set.onAdd(this::onEvent).join()));
        this.listeners.add((Listener<DistributedSet.ValueEvent<Object>>)((Listener)this.set.onRemove(this::onEvent).join()));
    }

    protected void doStop() throws Exception {
        this.listeners.forEach(Listener::close);
        super.doStop();
    }

    private void onEvent(DistributedSet.ValueEvent<Object> event) {
        Exchange exchange = this.createExchange(true);
        exchange.getIn().setHeader("CamelAtomixEventType", (Object)event.type());
        if (this.resultHeader == null) {
            exchange.getIn().setBody(event.value());
        } else {
            exchange.getIn().setHeader(this.resultHeader, event.value());
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }
}

