/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.set;

import io.atomix.Atomix;
import io.atomix.catalyst.transport.Address;
import io.atomix.resource.ReadConsistency;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atomix.client.set.AtomixSet;
import org.apache.camel.component.atomix.client.set.AtomixSetComponent;
import org.apache.camel.component.atomix.client.set.AtomixSetConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class AtomixSetComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private AtomixSetConfiguration getOrCreateConfiguration(AtomixSetComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new AtomixSetConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AtomixSetComponent target = (AtomixSetComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                this.getOrCreateConfiguration(target).setAtomix((Atomix)AtomixSetComponentConfigurer.property((CamelContext)camelContext, Atomix.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)AtomixSetComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)AtomixSetComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((AtomixSetConfiguration)AtomixSetComponentConfigurer.property((CamelContext)camelContext, AtomixSetConfiguration.class, (Object)value));
                return true;
            }
            case "configurationuri": 
            case "configurationUri": {
                target.setConfigurationUri((String)AtomixSetComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "defaultaction": 
            case "defaultAction": {
                this.getOrCreateConfiguration(target).setDefaultAction((AtomixSet.Action)((Object)AtomixSetComponentConfigurer.property((CamelContext)camelContext, AtomixSet.Action.class, (Object)value)));
                return true;
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                this.getOrCreateConfiguration(target).setDefaultResourceConfig((Properties)AtomixSetComponentConfigurer.property((CamelContext)camelContext, Properties.class, (Object)value));
                return true;
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                this.getOrCreateConfiguration(target).setDefaultResourceOptions((Properties)AtomixSetComponentConfigurer.property((CamelContext)camelContext, Properties.class, (Object)value));
                return true;
            }
            case "ephemeral": {
                this.getOrCreateConfiguration(target).setEphemeral((Boolean)AtomixSetComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)AtomixSetComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "nodes": {
                target.setNodes((List)AtomixSetComponentConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "readconsistency": 
            case "readConsistency": {
                this.getOrCreateConfiguration(target).setReadConsistency((ReadConsistency)AtomixSetComponentConfigurer.property((CamelContext)camelContext, ReadConsistency.class, (Object)value));
                return true;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                this.getOrCreateConfiguration(target).setResourceConfigs((Map)AtomixSetComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                this.getOrCreateConfiguration(target).setResourceOptions((Map)AtomixSetComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "resultheader": 
            case "resultHeader": {
                this.getOrCreateConfiguration(target).setResultHeader((String)AtomixSetComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "transportclassname": 
            case "transportClassName": {
                this.getOrCreateConfiguration(target).setTransportClassName((String)AtomixSetComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ttl": {
                this.getOrCreateConfiguration(target).setTtl(((Duration)AtomixSetComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
        }
        return false;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                return Atomix.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return AtomixSetConfiguration.class;
            }
            case "configurationuri": 
            case "configurationUri": {
                return String.class;
            }
            case "defaultaction": 
            case "defaultAction": {
                return AtomixSet.Action.class;
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                return Properties.class;
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                return Properties.class;
            }
            case "ephemeral": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "nodes": {
                return List.class;
            }
            case "readconsistency": 
            case "readConsistency": {
                return ReadConsistency.class;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return Map.class;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return Map.class;
            }
            case "resultheader": 
            case "resultHeader": {
                return String.class;
            }
            case "transportclassname": 
            case "transportClassName": {
                return String.class;
            }
            case "ttl": {
                return Long.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AtomixSetComponent target = (AtomixSetComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "atomix": {
                return this.getOrCreateConfiguration(target).getAtomix();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "configurationuri": 
            case "configurationUri": {
                return target.getConfigurationUri();
            }
            case "defaultaction": 
            case "defaultAction": {
                return this.getOrCreateConfiguration(target).getDefaultAction();
            }
            case "defaultresourceconfig": 
            case "defaultResourceConfig": {
                return this.getOrCreateConfiguration(target).getDefaultResourceConfig();
            }
            case "defaultresourceoptions": 
            case "defaultResourceOptions": {
                return this.getOrCreateConfiguration(target).getDefaultResourceOptions();
            }
            case "ephemeral": {
                return this.getOrCreateConfiguration(target).isEphemeral();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "nodes": {
                return target.getNodes();
            }
            case "readconsistency": 
            case "readConsistency": {
                return this.getOrCreateConfiguration(target).getReadConsistency();
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return this.getOrCreateConfiguration(target).getResourceConfigs();
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return this.getOrCreateConfiguration(target).getResourceOptions();
            }
            case "resultheader": 
            case "resultHeader": {
                return this.getOrCreateConfiguration(target).getResultHeader();
            }
            case "transportclassname": 
            case "transportClassName": {
                return this.getOrCreateConfiguration(target).getTransportClassName();
            }
            case "ttl": {
                return this.getOrCreateConfiguration(target).getTtl();
            }
        }
        return null;
    }

    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "nodes": {
                return Address.class;
            }
            case "resourceconfigs": 
            case "resourceConfigs": {
                return Properties.class;
            }
            case "resourceoptions": 
            case "resourceOptions": {
                return Properties.class;
            }
        }
        return null;
    }
}

