/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.cluster;

import io.atomix.AtomixReplica;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.copycat.server.storage.Storage;
import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atomix.cluster.AtomixClusterConfiguration;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;

public final class AtomixClusterHelper {
    private AtomixClusterHelper() {
    }

    public static AtomixReplica createReplica(CamelContext camelContext, String address, AtomixClusterConfiguration configuration) throws Exception {
        return AtomixClusterHelper.createReplica(camelContext, new Address(address), configuration);
    }

    public static AtomixReplica createReplica(CamelContext camelContext, Address address, AtomixClusterConfiguration configuration) throws Exception {
        AtomixReplica atomix = (AtomixReplica)configuration.getAtomix();
        if (atomix == null) {
            AtomixReplica.Builder atomixBuilder;
            String uri = configuration.getConfigurationUri();
            if (ObjectHelper.isNotEmpty((Object)uri)) {
                uri = camelContext.resolvePropertyPlaceholders(uri);
                try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)uri);){
                    Properties properties = new Properties();
                    properties.load(is);
                    atomixBuilder = AtomixReplica.builder((Address)address, (Properties)properties);
                }
            } else {
                atomixBuilder = AtomixReplica.builder((Address)address);
            }
            Storage.Builder storageBuilder = Storage.builder();
            ObjectHelper.ifNotEmpty((Object)configuration.getStorageLevel(), arg_0 -> ((Storage.Builder)storageBuilder).withStorageLevel(arg_0));
            ObjectHelper.ifNotEmpty((Object)configuration.getStoragePath(), arg_0 -> ((Storage.Builder)storageBuilder).withDirectory(arg_0));
            atomixBuilder.withStorage(storageBuilder.build());
            if (configuration.getTransportClassName() != null) {
                Class clazz = camelContext.getClassResolver().resolveMandatoryClass(configuration.getTransportClassName(), Transport.class);
                atomixBuilder.withTransport((Transport)camelContext.getInjector().newInstance(clazz));
            }
            if (configuration.getClientTransport() != null) {
                atomixBuilder.withClientTransport((Transport)camelContext.getInjector().newInstance(configuration.getClientTransport()));
            }
            if (configuration.getServerTransport() != null) {
                atomixBuilder.withServerTransport((Transport)camelContext.getInjector().newInstance(configuration.getServerTransport()));
            }
            atomix = atomixBuilder.build();
        }
        return atomix;
    }
}

