/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.attachment;

import jakarta.activation.DataHandler;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;

public class CSimpleAttachmentHelper {
    public static Map<String, DataHandler> attachments(Exchange exchange) {
        Message message = exchange.getMessage();
        if (message instanceof AttachmentMessage) {
            AttachmentMessage am = (AttachmentMessage)message;
            return am.getAttachments();
        }
        return null;
    }

    public static int attachmentsSize(Exchange exchange) {
        Message message = exchange.getMessage();
        if (message instanceof AttachmentMessage) {
            AttachmentMessage am = (AttachmentMessage)message;
            return am.getAttachments().size();
        }
        return 0;
    }

    public static Object attachmentContent(Exchange exchange, String key) throws Exception {
        AttachmentMessage am;
        DataHandler dh;
        Message message = exchange.getMessage();
        if (message instanceof AttachmentMessage && (dh = (am = (AttachmentMessage)message).getAttachments().get(key)) != null) {
            return dh.getContent();
        }
        return null;
    }

    public static Object attachmentContentAsText(Exchange exchange, String key) throws Exception {
        Object data = CSimpleAttachmentHelper.attachmentContent(exchange, key);
        if (data != null) {
            return exchange.getContext().getTypeConverter().convertTo(String.class, exchange, data);
        }
        return null;
    }

    public static <T> T attachmentContentAs(Exchange exchange, String key, Class<T> type) throws Exception {
        Object data = CSimpleAttachmentHelper.attachmentContent(exchange, key);
        if (data != null) {
            return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, data);
        }
        return null;
    }

    public static String attachmentContentType(Exchange exchange, String key) {
        AttachmentMessage am;
        DataHandler dh;
        Message message = exchange.getMessage();
        if (message instanceof AttachmentMessage && (dh = (am = (AttachmentMessage)message).getAttachments().get(key)) != null) {
            return dh.getContentType();
        }
        return null;
    }

    public static String attachmentHeader(Exchange exchange, String key, String name) {
        AttachmentMessage am;
        Attachment ao;
        Message message = exchange.getMessage();
        if (message instanceof AttachmentMessage && (ao = (am = (AttachmentMessage)message).getAttachmentObjects().get(key)) != null) {
            return ao.getHeader(name);
        }
        return null;
    }

    public static <T> T attachmentHeaderAs(Exchange exchange, String key, String name, Class<T> type) {
        String data = CSimpleAttachmentHelper.attachmentHeader(exchange, key, name);
        if (data != null) {
            return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, (Object)data);
        }
        return null;
    }
}

