/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.avro.reflect.ReflectData;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.avro.AvroConfiguration;
import org.apache.camel.component.avro.AvroConstants;
import org.apache.camel.component.avro.AvroConsumer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.10.0", scheme="avro", title="Avro RPC", syntax="avro:transport:host:port/messageName", category={Category.RPC}, headersClass=AvroConstants.class)
public abstract class AvroEndpoint
extends DefaultEndpoint
implements AsyncEndpoint {
    @UriParam
    private AvroConfiguration configuration;

    public AvroEndpoint(String endpointUri, Component component, AvroConfiguration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
    }

    public boolean isSingletonProducer() {
        return false;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        AvroConsumer consumer = new AvroConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public AvroConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.validateConfiguration(this.configuration);
    }

    private void validateConfiguration(AvroConfiguration config) throws Exception {
        Class protocolClass;
        if (config.getProtocol() == null && config.getProtocolClassName() != null && (protocolClass = this.getCamelContext().getClassResolver().resolveClass(config.getProtocolClassName())) != null) {
            try {
                Field f = protocolClass.getField("PROTOCOL");
                if (f != null) {
                    Protocol protocol = (Protocol)f.get(null);
                    config.setProtocol(protocol);
                }
            }
            catch (NoSuchFieldException e) {
                ReflectData reflectData = ReflectData.get();
                config.setProtocol(reflectData.getProtocol(protocolClass));
                config.setReflectionProtocol(true);
            }
        }
        if (config.getProtocol() == null) {
            throw new IllegalArgumentException("Avro configuration does not contain protocol");
        }
        if (config.getMessageName() != null && !config.getProtocol().getMessages().containsKey(config.getMessageName())) {
            throw new IllegalArgumentException("Message " + config.getMessageName() + " is not defined in protocol");
        }
        if (config.isSingleParameter()) {
            Map messageMap = config.getProtocol().getMessages();
            Collection messagesToCheck = config.getMessageName() == null ? messageMap.values() : Collections.singleton((Protocol.Message)messageMap.get(config.getMessageName()));
            for (Protocol.Message message : messagesToCheck) {
                if (message.getRequest().getFields().size() == 1) continue;
                throw new IllegalArgumentException("Single parameter option can't be used with message " + message.getName() + " because it has " + message.getRequest().getFields().size() + " parameters defined");
            }
        }
    }
}

