/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import java.net.URI;
import org.apache.avro.Protocol;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.avro.AvroTransport;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.commons.lang3.StringUtils;

@UriParams
public class AvroConfiguration
implements Cloneable {
    @UriPath
    @Metadata(required=true)
    private AvroTransport transport;
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriPath
    @Metadata(required=true)
    private int port;
    @UriPath
    private String messageName;
    @UriParam
    private String protocolLocation;
    @UriParam
    private Protocol protocol;
    @UriParam
    private String protocolClassName;
    @UriParam
    private String uriAuthority;
    @UriParam
    private boolean reflectionProtocol;
    @UriParam
    private boolean singleParameter;

    public AvroConfiguration copy() {
        try {
            return (AvroConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void parseURI(URI uri) throws Exception {
        this.transport = AvroTransport.valueOf(uri.getScheme());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        if (uri.getPath() != null && StringUtils.indexOf((CharSequence)uri.getPath(), (CharSequence)"/") != -1) {
            String path = StringUtils.substringAfter((String)uri.getPath(), (String)"/");
            if (!path.contains("/")) {
                this.setMessageName(path);
            } else {
                throw new IllegalArgumentException("Unrecognized Avro message name: " + path + " for uri: " + String.valueOf(uri));
            }
        }
        this.setUriAuthority(uri.getAuthority());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public AvroTransport getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = AvroTransport.valueOf(transport);
    }

    public void setTransport(AvroTransport transport) {
        this.transport = transport;
    }

    public String getProtocolLocation() {
        return this.protocolLocation;
    }

    public void setProtocolLocation(String protocolLocation) {
        this.protocolLocation = protocolLocation;
    }

    public String getProtocolClassName() {
        return this.protocolClassName;
    }

    public void setProtocolClassName(String protocolClassName) {
        this.protocolClassName = protocolClassName;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    public String getUriAuthority() {
        return this.uriAuthority;
    }

    public void setUriAuthority(String uriAuthority) {
        this.uriAuthority = uriAuthority;
    }

    public boolean isReflectionProtocol() {
        return this.reflectionProtocol;
    }

    public void setReflectionProtocol(boolean isReflectionProtocol) {
        this.reflectionProtocol = isReflectionProtocol;
    }

    public boolean isSingleParameter() {
        return this.singleParameter;
    }

    public void setSingleParameter(boolean singleParameter) {
        this.singleParameter = singleParameter;
    }
}

