/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro.springboot;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.avro.AvroComponent;
import org.apache.camel.component.avro.springboot.AvroComponentConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AvroComponentConfiguration.class})
public class AvroComponentAutoConfiguration {
    @Bean(name={"avro-component"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={AvroComponent.class})
    public AvroComponent configureAvroComponent(CamelContext camelContext, AvroComponentConfiguration configuration) throws Exception {
        AvroComponent component = new AvroComponent();
        component.setCamelContext(camelContext);
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)configuration, parameters, null, (boolean)false);
        for (Map.Entry entry : parameters.entrySet()) {
            Object value = entry.getValue();
            Class<?> paramClass = value.getClass();
            if (!paramClass.getName().endsWith("NestedConfiguration")) continue;
            Class nestedClass = null;
            try {
                nestedClass = (Class)paramClass.getDeclaredField("CAMEL_NESTED_CLASS").get(null);
                HashMap nestedParameters = new HashMap();
                IntrospectionSupport.getProperties(value, nestedParameters, null, (boolean)false);
                Object nestedProperty = nestedClass.newInstance();
                IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), nestedProperty, nestedParameters);
                entry.setValue(nestedProperty);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), (Object)component, parameters);
        return component;
    }
}

