/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.avro.AvroConfiguration;
import org.apache.camel.impl.DefaultEndpoint;

public abstract class AvroEndpoint
extends DefaultEndpoint {
    private AvroConfiguration configuration;

    public AvroEndpoint(String endpointUri, Component component, AvroConfiguration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
    }

    public Exchange createExchange(Protocol.Message message, Object request) {
        ExchangePattern pattern = ExchangePattern.InOut;
        if (message.getResponse().equals((Object)Schema.Type.NULL)) {
            pattern = ExchangePattern.InOnly;
        }
        Exchange exchange = this.createExchange(pattern);
        exchange.getIn().setBody(request);
        exchange.getIn().setHeader("CamelAvroMessageName", (Object)message.getName());
        return exchange;
    }

    public boolean isSingleton() {
        return true;
    }

    public AvroConfiguration getConfiguration() {
        return this.configuration;
    }

    public Protocol getProtocol() {
        return this.configuration.getProtocol();
    }
}

