/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.avro;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

public class AvroDataFormat
implements DataFormat {
    private Schema schema;
    private String instanceClassName;

    public AvroDataFormat() {
    }

    public AvroDataFormat(Schema schema) {
        this.schema = schema;
    }

    public synchronized Schema getSchema(Exchange exchange, Object graph) throws Exception {
        if (this.schema == null) {
            if (this.instanceClassName != null) {
                return this.loadDefaultSchema(this.instanceClassName, exchange.getContext());
            }
            if (graph != null && graph instanceof GenericContainer) {
                return this.loadDefaultSchema(graph.getClass().getName(), exchange.getContext());
            }
            throw new CamelException("There is not schema for avro marshaling / unmarshaling");
        }
        return this.schema;
    }

    public void setSchema(Object schema) {
        if (!(schema instanceof Schema)) {
            throw new IllegalArgumentException("The argument for setDefaultInstance should be subClass of " + Schema.class.getName());
        }
        this.schema = (Schema)schema;
    }

    public void setInstanceClass(String className) throws Exception {
        ObjectHelper.notNull((Object)className, (String)"AvroDataFormat messageClass");
        this.instanceClassName = className;
    }

    protected Schema loadDefaultSchema(String className, CamelContext context) throws CamelException, ClassNotFoundException {
        Class instanceClass = context.getClassResolver().resolveMandatoryClass(className);
        if (GenericContainer.class.isAssignableFrom(instanceClass)) {
            try {
                Method method = instanceClass.getMethod("getSchema", new Class[0]);
                return (Schema)method.invoke(instanceClass.newInstance(), new Object[0]);
            }
            catch (Exception ex) {
                throw new CamelException("Can't set the defaultInstance of AvroDataFormat with " + className + ", caused by " + ex);
            }
        }
        throw new CamelException("Can't set the shcema of AvroDataFormat with " + className + ", as the class is not a subClass of SpecificData");
    }

    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        SpecificDatumWriter datum = new SpecificDatumWriter(this.getSchema(exchange, graph));
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(outputStream, null);
        datum.write(graph, (Encoder)encoder);
        encoder.flush();
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        SpecificDatumReader reader = new SpecificDatumReader(this.getSchema(exchange, null));
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(inputStream, null);
        Object result = reader.read(null, (Decoder)decoder);
        return result;
    }
}

