/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import org.apache.avro.ipc.Callback;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.avro.AvroEndpoint;
import org.apache.camel.component.avro.AvroRequestor;
import org.apache.camel.impl.DefaultAsyncProducer;

public abstract class AvroProducer
extends DefaultAsyncProducer
implements ServicePoolAware {
    Transceiver transceiver;
    Requestor requestor;

    public AvroProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public abstract Transceiver createTransceiver() throws Exception;

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Object request = exchange.getIn().getBody();
        try {
            this.requestor.request((String)exchange.getIn().getHeader("CamelAvroMessageName", String.class), (Object)this.wrapObjectToArray(request), (Callback)new Callback<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleResult(Object result) {
                    try {
                        exchange.getOut().setHeaders(exchange.getIn().getHeaders());
                        exchange.getOut().setBody(result);
                    }
                    finally {
                        callback.done(false);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleError(Throwable error) {
                    try {
                        exchange.setException(error);
                    }
                    finally {
                        callback.done(false);
                    }
                }
            });
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    public Object[] wrapObjectToArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        Object[] wrapper = new Object[]{object};
        return wrapper;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.transceiver = this.createTransceiver();
        this.requestor = new AvroRequestor(this.getEndpoint().getProtocol(), this.transceiver);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.transceiver != null) {
            this.transceiver.close();
        }
        this.requestor = null;
    }

    public AvroEndpoint getEndpoint() {
        return (AvroEndpoint)super.getEndpoint();
    }
}

