/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime.client;

import org.apache.camel.component.aws2.bedrock.runtime.BedrockConfiguration;
import org.apache.camel.component.aws2.bedrock.runtime.client.BedrockRuntimeInternalClient;
import org.apache.camel.component.aws2.bedrock.runtime.client.impl.BedrockRuntimeClientIAMOptimizedImpl;
import org.apache.camel.component.aws2.bedrock.runtime.client.impl.BedrockRuntimeClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.bedrock.runtime.client.impl.BedrockRuntimeClientSessionTokenImpl;
import org.apache.camel.component.aws2.bedrock.runtime.client.impl.BedrockRuntimeClientStandardImpl;

public final class BedrockClientFactory {
    private BedrockClientFactory() {
    }

    public static BedrockRuntimeInternalClient getBedrockRuntimeClient(BedrockConfiguration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new BedrockRuntimeClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new BedrockRuntimeClientIAMProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new BedrockRuntimeClientSessionTokenImpl(configuration);
        }
        return new BedrockRuntimeClientStandardImpl(configuration);
    }
}

