/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.agentruntime;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.bedrock.agentruntime.BedrockAgentRuntimeComponent;
import org.apache.camel.component.aws2.bedrock.agentruntime.BedrockAgentRuntimeConfiguration;
import org.apache.camel.component.aws2.bedrock.agentruntime.BedrockAgentRuntimeConstants;
import org.apache.camel.component.aws2.bedrock.agentruntime.BedrockAgentRuntimeProducer;
import org.apache.camel.component.aws2.bedrock.agentruntime.client.BedrockAgentRuntimeClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;

@UriEndpoint(firstVersion="4.5.0", scheme="aws-bedrock-agent-runtime", title="AWS Bedrock Agent Runtime", syntax="aws-bedrock-agent-runtime:label", producerOnly=true, category={Category.AI, Category.CLOUD}, headersClass=BedrockAgentRuntimeConstants.class)
public class BedrockAgentRuntimeEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private BedrockAgentRuntimeClient bedrockAgentRuntimeClient;
    @UriParam
    private BedrockAgentRuntimeConfiguration configuration;

    public BedrockAgentRuntimeEndpoint(String uri, Component component, BedrockAgentRuntimeConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new BedrockAgentRuntimeProducer((Endpoint)this);
    }

    public BedrockAgentRuntimeComponent getComponent() {
        return (BedrockAgentRuntimeComponent)super.getComponent();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.bedrockAgentRuntimeClient = this.configuration.getBedrockAgentRuntimeClient() != null ? this.configuration.getBedrockAgentRuntimeClient() : BedrockAgentRuntimeClientFactory.getBedrockAgentRuntimeClient(this.configuration).getBedrockAgentRuntimeClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getBedrockAgentRuntimeClient()) && this.bedrockAgentRuntimeClient != null) {
            this.bedrockAgentRuntimeClient.close();
        }
        super.doStop();
    }

    public BedrockAgentRuntimeConfiguration getConfiguration() {
        return this.configuration;
    }

    public BedrockAgentRuntimeClient getBedrockAgentRuntimeClient() {
        return this.bedrockAgentRuntimeClient;
    }

    public String getServiceUrl() {
        if (!this.configuration.isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                return this.configuration.getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.configuration.getUriEndpointOverride())) {
            return this.configuration.getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "bedrock-agent-runtime";
    }

    public Map<String, String> getServiceMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.configuration.getModelId() != null) {
            metadata.put("modelId", this.configuration.getModelId());
        }
        return metadata;
    }
}

