/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.agent;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.bedrock.agent.BedrockAgentConfiguration;
import org.apache.camel.component.aws2.bedrock.agent.BedrockAgentEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="aws-bedrock-agent")
public class BedrockAgentComponent
extends HealthCheckComponent {
    @Metadata
    private BedrockAgentConfiguration configuration = new BedrockAgentConfiguration();

    public BedrockAgentComponent() {
        this(null);
    }

    public BedrockAgentComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BedrockAgentConfiguration configuration = this.configuration != null ? this.configuration.copy() : new BedrockAgentConfiguration();
        BedrockAgentEndpoint endpoint = new BedrockAgentEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseSessionCredentials()) && configuration.getBedrockAgentClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, useSessionCredentials is set to false, Amazon Bedrock runtime client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public BedrockAgentConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BedrockAgentConfiguration configuration) {
        this.configuration = configuration;
    }
}

