/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cloudtrail;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.cloudtrail.CloudtrailConfiguration;
import org.apache.camel.component.aws.cloudtrail.CloudtrailEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;

@Component(value="aws-cloudtrail")
public class CloudtrailComponent
extends HealthCheckComponent {
    @Metadata
    private CloudtrailConfiguration configuration = new CloudtrailConfiguration();

    public CloudtrailComponent() {
        this(null);
    }

    public CloudtrailComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CloudtrailConfiguration configuration = this.configuration != null ? this.configuration.copy() : new CloudtrailConfiguration();
        configuration.setLabel(remaining);
        CloudtrailEndpoint endpoint = new CloudtrailEndpoint(uri, configuration, this);
        this.setProperties((Endpoint)endpoint, parameters);
        if (!(configuration.isUseDefaultCredentialsProvider() || configuration.isUseProfileCredentialsProvider() || configuration.isUseSessionCredentials() || configuration.getCloudTrailClient() != null || configuration.getAccessKey() != null && configuration.getSecretKey() != null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, useSessionCredentials is set to false, cloudTrailClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public CloudtrailConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CloudtrailConfiguration configuration) {
        this.configuration = configuration;
    }
}

