/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.ddb.DdbComponentVerifierExtension;
import org.apache.camel.component.aws.ddb.DdbConfiguration;
import org.apache.camel.component.aws.ddb.DdbEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-ddb")
public class DdbComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private DdbConfiguration configuration;

    public DdbComponent() {
        this(null);
    }

    public DdbComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new DdbComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Table name must be specified.");
        }
        DdbConfiguration configuration = this.configuration != null ? this.configuration.copy() : new DdbConfiguration();
        configuration.setTableName(remaining);
        DdbEndpoint endpoint = new DdbEndpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonDDBClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonDDBClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public DdbConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DdbConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(DdbConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonDynamoDB.class);
        if (clients.size() == 1) {
            configuration.setAmazonDDBClient((AmazonDynamoDB)clients.stream().findFirst().get());
        }
    }
}

