/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddbstream;

import com.amazonaws.Protocol;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.model.ShardIteratorType;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.ddbstream.DdbStreamComponent;
import org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration;
import org.apache.camel.component.aws.ddbstream.SequenceNumberProvider;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class DdbStreamComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private DdbStreamConfiguration getOrCreateConfiguration(DdbStreamComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new DdbStreamConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DdbStreamComponent target = (DdbStreamComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)DdbStreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazondynamodbstreamsclient": 
            case "amazonDynamoDbStreamsClient": {
                this.getOrCreateConfiguration(target).setAmazonDynamoDbStreamsClient((AmazonDynamoDBStreams)DdbStreamComponentConfigurer.property((CamelContext)camelContext, AmazonDynamoDBStreams.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((DdbStreamConfiguration)DdbStreamComponentConfigurer.property((CamelContext)camelContext, DdbStreamConfiguration.class, (Object)value));
                return true;
            }
            case "iteratortype": 
            case "iteratorType": {
                this.getOrCreateConfiguration(target).setIteratorType((ShardIteratorType)DdbStreamComponentConfigurer.property((CamelContext)camelContext, ShardIteratorType.class, (Object)value));
                return true;
            }
            case "maxresultsperrequest": 
            case "maxResultsPerRequest": {
                this.getOrCreateConfiguration(target).setMaxResultsPerRequest((Integer)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)DdbStreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)DdbStreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)DdbStreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sequencenumberprovider": 
            case "sequenceNumberProvider": {
                this.getOrCreateConfiguration(target).setSequenceNumberProvider((SequenceNumberProvider)DdbStreamComponentConfigurer.property((CamelContext)camelContext, SequenceNumberProvider.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonDynamoDbStreamsClient", AmazonDynamoDBStreams.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("configuration", DdbStreamConfiguration.class);
        answer.put("iteratorType", ShardIteratorType.class);
        answer.put("maxResultsPerRequest", Integer.TYPE);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        answer.put("sequenceNumberProvider", SequenceNumberProvider.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DdbStreamComponent target = (DdbStreamComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazondynamodbstreamsclient": 
            case "amazonDynamoDbStreamsClient": {
                return this.getOrCreateConfiguration(target).getAmazonDynamoDbStreamsClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "iteratortype": 
            case "iteratorType": {
                return this.getOrCreateConfiguration(target).getIteratorType();
            }
            case "maxresultsperrequest": 
            case "maxResultsPerRequest": {
                return this.getOrCreateConfiguration(target).getMaxResultsPerRequest();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "sequencenumberprovider": 
            case "sequenceNumberProvider": {
                return this.getOrCreateConfiguration(target).getSequenceNumberProvider();
            }
        }
        return null;
    }
}

