/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddbstream;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClientBuilder;
import com.amazonaws.services.dynamodbv2.model.Record;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.ddbstream.DdbStreamComponent;
import org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration;
import org.apache.camel.component.aws.ddbstream.DdbStreamConsumer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.17.0", scheme="aws-ddbstream", title="AWS DynamoDB Streams", consumerOnly=true, syntax="aws-ddbstream:tableName", label="cloud,messaging,streams")
public class DdbStreamEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    DdbStreamConfiguration configuration;
    private AmazonDynamoDBStreams ddbStreamClient;

    public DdbStreamEndpoint(String uri, DdbStreamConfiguration configuration, DdbStreamComponent component) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DdbStreamConsumer consumer = new DdbStreamConsumer(this, processor);
        consumer.setSchedulerProperties(consumer.getEndpoint().getSchedulerProperties());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    Exchange createExchange(Record record) {
        Exchange ex = super.createExchange();
        ex.getIn().setBody((Object)record, Record.class);
        return ex;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.ddbStreamClient = this.configuration.getAmazonDynamoDbStreamsClient() != null ? this.configuration.getAmazonDynamoDbStreamsClient() : this.createDdbStreamClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonDynamoDbStreamsClient()) && this.ddbStreamClient != null) {
            this.ddbStreamClient.shutdown();
        }
        super.doStop();
    }

    public DdbStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonDynamoDBStreams getClient() {
        return this.ddbStreamClient;
    }

    public String getSequenceNumber() {
        switch (this.configuration.getIteratorType()) {
            case AFTER_SEQUENCE_NUMBER: 
            case AT_SEQUENCE_NUMBER: {
                if (null == this.configuration.getSequenceNumberProvider()) {
                    throw new IllegalStateException("sequenceNumberProvider must be provided, either as an implementation of SequenceNumberProvider or a literal String.");
                }
                return this.configuration.getSequenceNumberProvider().getSequenceNumber();
            }
        }
        return "";
    }

    AmazonDynamoDBStreams createDdbStreamClient() {
        AmazonDynamoDBStreams client = null;
        ClientConfiguration clientConfiguration = null;
        AmazonDynamoDBStreamsClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonDynamoDBStreamsClientBuilder)((AmazonDynamoDBStreamsClientBuilder)AmazonDynamoDBStreamsClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonDynamoDBStreamsClientBuilder)AmazonDynamoDBStreamsClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonDynamoDBStreamsClientBuilder.standard() : (AmazonDynamoDBStreamsClientBuilder)AmazonDynamoDBStreamsClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonDynamoDBStreamsClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        client = (AmazonDynamoDBStreams)clientBuilder.build();
        return client;
    }

    public String toString() {
        return "DdbStreamEndpoint{tableName=" + this.configuration.getTableName() + ", amazonDynamoDbStreamsClient=[redacted], maxResultsPerRequest=" + this.configuration.getMaxResultsPerRequest() + ", iteratorType=" + this.configuration.getIteratorType() + ", sequenceNumberProvider=" + this.configuration.getSequenceNumberProvider() + ", uri=" + this.getEndpointUri() + '}';
    }
}

