/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ec2;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.ec2.EC2Configuration;
import org.apache.camel.component.aws.ec2.EC2Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.16.0", scheme="aws-ec2", title="AWS EC2", syntax="aws-ec2:label", producerOnly=true, label="cloud,management")
public class EC2Endpoint
extends ScheduledPollEndpoint {
    private AmazonEC2Client ec2Client;
    @UriParam
    private EC2Configuration configuration;

    public EC2Endpoint(String uri, Component component, EC2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new EC2Producer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.ec2Client = this.configuration.getAmazonEc2Client() != null ? this.configuration.getAmazonEc2Client() : (AmazonEC2Client)this.createEc2Client();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonEc2Client()) && this.ec2Client != null) {
            this.ec2Client.shutdown();
        }
        super.doStop();
    }

    public EC2Configuration getConfiguration() {
        return this.configuration;
    }

    public AmazonEC2Client getEc2Client() {
        return this.ec2Client;
    }

    AmazonEC2 createEc2Client() {
        AmazonEC2 client = null;
        ClientConfiguration clientConfiguration = null;
        AmazonEC2ClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonEC2ClientBuilder.standard() : (AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonEC2ClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        client = (AmazonEC2)clientBuilder.build();
        return client;
    }
}

