/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.ec2.EC2Endpoint;
import org.apache.camel.component.aws.ec2.EC2Operations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class EC2EndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return EC2EndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return EC2EndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "amazonEc2Client": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setAmazonEc2Client((AmazonEC2)EC2EndpointConfigurer.property((CamelContext)camelContext, AmazonEC2.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)EC2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)EC2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setOperation((EC2Operations)((Object)EC2EndpointConfigurer.property((CamelContext)camelContext, EC2Operations.class, (Object)value)));
                return true;
            }
            case "proxyHost": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)EC2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)EC2EndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setRegion((String)EC2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((EC2Endpoint)((Object)endpoint)).setStartScheduler((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((EC2Endpoint)((Object)endpoint)).setInitialDelay((Long)EC2EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((EC2Endpoint)((Object)endpoint)).setDelay((Long)EC2EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((EC2Endpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)EC2EndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((EC2Endpoint)((Object)endpoint)).setUseFixedDelay((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((EC2Endpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)EC2EndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((EC2Endpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)EC2EndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((EC2Endpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((EC2Endpoint)((Object)endpoint)).setGreedy((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((EC2Endpoint)((Object)endpoint)).setScheduler((String)EC2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((EC2Endpoint)((Object)endpoint)).setSchedulerProperties((Map)EC2EndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((EC2Endpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)EC2EndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((EC2Endpoint)((Object)endpoint)).setBackoffMultiplier((Integer)EC2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((EC2Endpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)EC2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((EC2Endpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)EC2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((EC2Endpoint)((Object)endpoint)).setLazyStartProducer((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((EC2Endpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((EC2Endpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)EC2EndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((EC2Endpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)EC2EndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((EC2Endpoint)((Object)endpoint)).setSynchronous((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((EC2Endpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "amazonec2client": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setAmazonEc2Client((AmazonEC2)EC2EndpointConfigurer.property((CamelContext)camelContext, AmazonEC2.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)EC2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)EC2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setOperation((EC2Operations)((Object)EC2EndpointConfigurer.property((CamelContext)camelContext, EC2Operations.class, (Object)value)));
                return true;
            }
            case "proxyhost": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)EC2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)EC2EndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((EC2Endpoint)((Object)endpoint)).getConfiguration().setRegion((String)EC2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((EC2Endpoint)((Object)endpoint)).setStartScheduler((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((EC2Endpoint)((Object)endpoint)).setInitialDelay((Long)EC2EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((EC2Endpoint)((Object)endpoint)).setDelay((Long)EC2EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((EC2Endpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)EC2EndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((EC2Endpoint)((Object)endpoint)).setUseFixedDelay((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((EC2Endpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)EC2EndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((EC2Endpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)EC2EndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((EC2Endpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((EC2Endpoint)((Object)endpoint)).setGreedy((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((EC2Endpoint)((Object)endpoint)).setScheduler((String)EC2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((EC2Endpoint)((Object)endpoint)).setSchedulerProperties((Map)EC2EndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((EC2Endpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)EC2EndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((EC2Endpoint)((Object)endpoint)).setBackoffMultiplier((Integer)EC2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((EC2Endpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)EC2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((EC2Endpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)EC2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((EC2Endpoint)((Object)endpoint)).setLazyStartProducer((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((EC2Endpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((EC2Endpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)EC2EndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((EC2Endpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)EC2EndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((EC2Endpoint)((Object)endpoint)).setSynchronous((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((EC2Endpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)EC2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

