/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ec2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.CreateTagsResult;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.DeleteTagsResult;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.MonitorInstancesRequest;
import com.amazonaws.services.ec2.model.MonitorInstancesResult;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.RebootInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.StopInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.amazonaws.services.ec2.model.UnmonitorInstancesRequest;
import com.amazonaws.services.ec2.model.UnmonitorInstancesResult;
import java.util.Arrays;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.ec2.EC2Configuration;
import org.apache.camel.component.aws.ec2.EC2Endpoint;
import org.apache.camel.component.aws.ec2.EC2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class EC2Producer
extends DefaultProducer {
    private transient String ec2ProducerToString;

    public EC2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case createAndRunInstances: {
                this.createAndRunInstance(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case startInstances: {
                this.startInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case stopInstances: {
                this.stopInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case terminateInstances: {
                this.terminateInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case describeInstances: {
                this.describeInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case describeInstancesStatus: {
                this.describeInstancesStatus(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case rebootInstances: {
                this.rebootInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case monitorInstances: {
                this.monitorInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case unmonitorInstances: {
                this.unmonitorInstances(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case createTags: {
                this.createTags(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            case deleteTags: {
                this.deleteTags(this.getEndpoint().getEc2Client(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private EC2Operations determineOperation(Exchange exchange) {
        EC2Operations operation = (EC2Operations)((Object)exchange.getIn().getHeader("CamelAwsEC2Operation", EC2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected EC2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.ec2ProducerToString == null) {
            this.ec2ProducerToString = "EC2Producer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.ec2ProducerToString;
    }

    public EC2Endpoint getEndpoint() {
        return (EC2Endpoint)super.getEndpoint();
    }

    private void createAndRunInstance(AmazonEC2 ec2Client, Exchange exchange) {
        RunInstancesResult result;
        RunInstancesRequest request = new RunInstancesRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2ImageId"))) {
            throw new IllegalArgumentException("AMI must be specified");
        }
        String ami = (String)exchange.getIn().getHeader("CamelAwsEC2ImageId", String.class);
        request.withImageId(ami);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceType"))) {
            throw new IllegalArgumentException("Instance Type must be specified");
        }
        InstanceType instanceType = (InstanceType)exchange.getIn().getHeader("CamelAwsEC2InstanceType", InstanceType.class);
        request.withInstanceType(instanceType.toString());
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceMinCount"))) {
            throw new IllegalArgumentException("Min instances count must be specified");
        }
        int minCount = (Integer)exchange.getIn().getHeader("CamelAwsEC2InstanceMinCount", Integer.class);
        request.withMinCount(Integer.valueOf(minCount));
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceMaxCount"))) {
            throw new IllegalArgumentException("Max instances count must be specified");
        }
        int maxCount = (Integer)exchange.getIn().getHeader("CamelAwsEC2InstanceMaxCount", Integer.class);
        request.withMaxCount(Integer.valueOf(maxCount));
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceMonitoring"))) {
            boolean monitoring = (Boolean)exchange.getIn().getHeader("CamelAwsEC2InstanceMonitoring", Boolean.class);
            request.withMonitoring(Boolean.valueOf(monitoring));
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceKernelId"))) {
            String kernelId = (String)exchange.getIn().getHeader("CamelAwsEC2InstanceKernelId", String.class);
            request.withKernelId(kernelId);
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceEbsOptimized"))) {
            boolean ebsOptimized = (Boolean)exchange.getIn().getHeader("CamelAwsEC2InstanceEbsOptimized", Boolean.class);
            request.withEbsOptimized(Boolean.valueOf(ebsOptimized));
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstanceSecurityGroups"))) {
            Collection securityGroups = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstanceSecurityGroups", Collection.class);
            request.withSecurityGroups(securityGroups);
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesKeyPair"))) {
            String keyName = (String)exchange.getIn().getHeader("CamelAwsEC2InstancesKeyPair", String.class);
            request.withKeyName(keyName);
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesClientToken"))) {
            String clientToken = (String)exchange.getIn().getHeader("CamelAwsEC2InstancesClientToken", String.class);
            request.withClientToken(clientToken);
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesPlacement"))) {
            Placement placement = (Placement)exchange.getIn().getHeader("CamelAwsEC2InstancesPlacement", Placement.class);
            request.withPlacement(placement);
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2SubnetId"))) {
            String subnetId = (String)exchange.getIn().getHeader("CamelAwsEC2SubnetId", String.class);
            request.withSubnetId(subnetId);
        }
        try {
            result = ec2Client.runInstances(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Run Instances command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        this.log.trace("Creating and running instances with ami [{}] and instance type {}", (Object)ami, (Object)instanceType);
        Message message = EC2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void startInstances(AmazonEC2 ec2Client, Exchange exchange) {
        StartInstancesResult result;
        StartInstancesRequest request = new StartInstancesRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
            throw new IllegalArgumentException("Instances Ids must be specified");
        }
        Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
        request.withInstanceIds(instanceIds);
        try {
            result = ec2Client.startInstances(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Start Instances command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        this.log.trace("Starting instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
        Message message = EC2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void stopInstances(AmazonEC2 ec2Client, Exchange exchange) {
        StopInstancesResult result;
        StopInstancesRequest request = new StopInstancesRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
            throw new IllegalArgumentException("Instances Ids must be specified");
        }
        Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
        request.withInstanceIds(instanceIds);
        try {
            result = ec2Client.stopInstances(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Stop Instances command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        this.log.trace("Stopping instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
        Message message = EC2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void terminateInstances(AmazonEC2 ec2Client, Exchange exchange) {
        TerminateInstancesResult result;
        TerminateInstancesRequest request = new TerminateInstancesRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
            throw new IllegalArgumentException("Instances Ids must be specified");
        }
        Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
        request.withInstanceIds(instanceIds);
        try {
            result = ec2Client.terminateInstances(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Terminate Instances command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        this.log.trace("Terminating instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
        Message message = EC2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void describeInstances(AmazonEC2 ec2Client, Exchange exchange) {
        DescribeInstancesResult result;
        DescribeInstancesRequest request = new DescribeInstancesRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
            Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
            request.withInstanceIds(instanceIds);
        }
        try {
            result = ec2Client.describeInstances(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Describe Instances command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = EC2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void describeInstancesStatus(AmazonEC2 ec2Client, Exchange exchange) {
        DescribeInstanceStatusResult result;
        DescribeInstanceStatusRequest request = new DescribeInstanceStatusRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
            Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
            request.withInstanceIds(instanceIds);
        }
        try {
            result = ec2Client.describeInstanceStatus(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Describe Instances Status command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = EC2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void rebootInstances(AmazonEC2 ec2Client, Exchange exchange) {
        RebootInstancesRequest request = new RebootInstancesRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
            throw new IllegalArgumentException("Instances Ids must be specified");
        }
        Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
        request.withInstanceIds(instanceIds);
        try {
            this.log.trace("Rebooting instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
            ec2Client.rebootInstances(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Reboot Instances command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
    }

    private void monitorInstances(AmazonEC2 ec2Client, Exchange exchange) {
        MonitorInstancesResult result;
        MonitorInstancesRequest request = new MonitorInstancesRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
            throw new IllegalArgumentException("Instances Ids must be specified");
        }
        Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
        request.withInstanceIds(instanceIds);
        try {
            result = ec2Client.monitorInstances(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Monitor Instances command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        this.log.trace("Start Monitoring instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
        Message message = EC2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void unmonitorInstances(AmazonEC2 ec2Client, Exchange exchange) {
        UnmonitorInstancesResult result;
        UnmonitorInstancesRequest request = new UnmonitorInstancesRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
            throw new IllegalArgumentException("Instances Ids must be specified");
        }
        Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
        request.withInstanceIds(instanceIds);
        try {
            result = ec2Client.unmonitorInstances(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Unmonitor Instances command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        this.log.trace("Stop Monitoring instances with Ids [{}] ", (Object)Arrays.toString(instanceIds.toArray()));
        Message message = EC2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createTags(AmazonEC2 ec2Client, Exchange exchange) {
        CreateTagsRequest request = new CreateTagsRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
            throw new IllegalArgumentException("Instances Ids must be specified");
        }
        Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
        request.withResources(instanceIds);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesTags"))) {
            throw new IllegalArgumentException("Tags must be specified");
        }
        Collection tags = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesTags", Collection.class);
        request.withTags(tags);
        CreateTagsResult result = new CreateTagsResult();
        try {
            result = ec2Client.createTags(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Create tags command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        this.log.trace("Created tags [{}] on resources with Ids [{}] ", (Object)Arrays.toString(tags.toArray()), (Object)Arrays.toString(instanceIds.toArray()));
        Message message = EC2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteTags(AmazonEC2 ec2Client, Exchange exchange) {
        DeleteTagsRequest request = new DeleteTagsRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesIds"))) {
            throw new IllegalArgumentException("Instances Ids must be specified");
        }
        Collection instanceIds = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesIds", Collection.class);
        request.withResources(instanceIds);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEC2InstancesTags"))) {
            throw new IllegalArgumentException("Tags must be specified");
        }
        Collection tags = (Collection)exchange.getIn().getHeader("CamelAwsEC2InstancesTags", Collection.class);
        request.withTags(tags);
        DeleteTagsResult result = new DeleteTagsResult();
        try {
            result = ec2Client.deleteTags(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Delete tags command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        this.log.trace("Delete tags [{}] on resources with Ids [{}] ", (Object)Arrays.toString(tags.toArray()), (Object)Arrays.toString(instanceIds.toArray()));
        Message message = EC2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }
}

