/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ecs;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.AmazonECSClientBuilder;
import com.amazonaws.services.ecs.model.ListClustersRequest;
import java.util.Map;
import org.apache.camel.component.aws.ecs.ECSConfiguration;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;

public class ECSComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public ECSComponentVerifierExtension() {
        this("aws-ecs");
    }

    public ECSComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"accessKey", parameters)).error(ResultErrorHelper.requiresOption((String)"secretKey", parameters)).error(ResultErrorHelper.requiresOption((String)"region", parameters));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY);
        try {
            ECSConfiguration configuration = (ECSConfiguration)this.setProperties(new ECSConfiguration(), parameters);
            BasicAWSCredentials credentials = new BasicAWSCredentials(configuration.getAccessKey(), configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            AmazonECS client = (AmazonECS)((AmazonECSClientBuilder)((AmazonECSClientBuilder)AmazonECSClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider)).withRegion(Regions.valueOf((String)configuration.getRegion()))).build();
            client.listClusters(new ListClustersRequest());
        }
        catch (SdkClientException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)e.getMessage()).detail("aws_ecs_exception_message", (Object)e.getMessage()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)((Object)((Object)e)).getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            builder.error(errorBuilder.build());
        }
        catch (Exception e) {
            builder.error(ResultErrorBuilder.withException((Exception)e).build());
        }
        return builder.build();
    }
}

