/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ecs;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.model.CreateClusterRequest;
import com.amazonaws.services.ecs.model.CreateClusterResult;
import com.amazonaws.services.ecs.model.DeleteClusterRequest;
import com.amazonaws.services.ecs.model.DeleteClusterResult;
import com.amazonaws.services.ecs.model.DescribeClustersRequest;
import com.amazonaws.services.ecs.model.DescribeClustersResult;
import com.amazonaws.services.ecs.model.ListClustersRequest;
import com.amazonaws.services.ecs.model.ListClustersResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.ecs.ECSConfiguration;
import org.apache.camel.component.aws.ecs.ECSEndpoint;
import org.apache.camel.component.aws.ecs.ECSOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECSProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ECSProducer.class);
    private transient String ecsProducerToString;

    public ECSProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listClusters: {
                this.listClusters(this.getEndpoint().getEcsClient(), exchange);
                break;
            }
            case describeCluster: {
                this.describeCluster(this.getEndpoint().getEcsClient(), exchange);
                break;
            }
            case createCluster: {
                this.createCluster(this.getEndpoint().getEcsClient(), exchange);
                break;
            }
            case deleteCluster: {
                this.deleteCluster(this.getEndpoint().getEcsClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private ECSOperations determineOperation(Exchange exchange) {
        ECSOperations operation = (ECSOperations)((Object)exchange.getIn().getHeader("CamelAwsECSOperation", ECSOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected ECSConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.ecsProducerToString == null) {
            this.ecsProducerToString = "ECSProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.ecsProducerToString;
    }

    public ECSEndpoint getEndpoint() {
        return (ECSEndpoint)super.getEndpoint();
    }

    private void listClusters(AmazonECS ecsClient, Exchange exchange) {
        ListClustersResult result;
        ListClustersRequest request = new ListClustersRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsECSMaxResults"))) {
            int maxRes = (Integer)exchange.getIn().getHeader("CamelAwsECSMaxResults", Integer.class);
            request.withMaxResults(Integer.valueOf(maxRes));
        }
        try {
            result = ecsClient.listClusters();
        }
        catch (AmazonServiceException ase) {
            LOG.trace("List Clusters command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = ECSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createCluster(AmazonECS ecsClient, Exchange exchange) {
        CreateClusterResult result;
        CreateClusterRequest request = new CreateClusterRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsECSClusterName"))) {
            String name = (String)exchange.getIn().getHeader("CamelAwsECSClusterName", String.class);
            request.withClusterName(name);
        }
        try {
            result = ecsClient.createCluster(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Create Cluster command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = ECSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void describeCluster(AmazonECS ecsClient, Exchange exchange) {
        DescribeClustersResult result;
        DescribeClustersRequest request = new DescribeClustersRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsECSClusterName"))) {
            String clusterName = (String)exchange.getIn().getHeader("CamelAwsECSClusterName", String.class);
            request.withClusters(new String[]{clusterName});
        }
        try {
            result = ecsClient.describeClusters(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Describe Clusters command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = ECSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteCluster(AmazonECS ecsClient, Exchange exchange) {
        DeleteClusterResult result;
        DeleteClusterRequest request = new DeleteClusterRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsECSClusterName"))) {
            throw new IllegalArgumentException("Cluster name must be specified");
        }
        String name = (String)exchange.getIn().getHeader("CamelAwsECSClusterName", String.class);
        request.withCluster(name);
        try {
            result = ecsClient.deleteCluster(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Delete Cluster command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = ECSProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

