/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ecs;

import com.amazonaws.services.ecs.AmazonECS;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.ecs.ECSComponentVerifierExtension;
import org.apache.camel.component.aws.ecs.ECSConfiguration;
import org.apache.camel.component.aws.ecs.ECSEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-ecs")
public class ECSComponent
extends DefaultComponent {
    @Metadata
    private ECSConfiguration configuration = new ECSConfiguration();

    public ECSComponent() {
        this(null);
    }

    public ECSComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new ECSComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ECSConfiguration configuration = this.configuration != null ? this.configuration.copy() : new ECSConfiguration();
        ECSEndpoint endpoint = new ECSEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration);
        }
        if (configuration.getEcsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon ecs client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public ECSConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ECSConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(ECSConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonECS.class);
        if (clients.size() == 1) {
            configuration.setEcsClient((AmazonECS)clients.stream().findFirst().get());
        }
    }
}

