/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.eks;

import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.eks.EKSComponent;
import org.apache.camel.component.aws.eks.EKSConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class EKSComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object component, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return EKSComponentConfigurer.doConfigureIgnoreCase(camelContext, component, name, value);
        }
        return EKSComponentConfigurer.doConfigure(camelContext, component, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object component, String name, Object value) {
        switch (name) {
            case "configuration": {
                ((EKSComponent)((Object)component)).setConfiguration((EKSConfiguration)EKSComponentConfigurer.property((CamelContext)camelContext, EKSConfiguration.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((EKSComponent)((Object)component)).setAccessKey((String)EKSComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((EKSComponent)((Object)component)).setSecretKey((String)EKSComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((EKSComponent)((Object)component)).setRegion((String)EKSComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((EKSComponent)((Object)component)).setBasicPropertyBinding((Boolean)EKSComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((EKSComponent)((Object)component)).setLazyStartProducer((Boolean)EKSComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((EKSComponent)((Object)component)).setBridgeErrorHandler((Boolean)EKSComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object component, String name, Object value) {
        switch (name.toLowerCase()) {
            case "configuration": {
                ((EKSComponent)((Object)component)).setConfiguration((EKSConfiguration)EKSComponentConfigurer.property((CamelContext)camelContext, EKSConfiguration.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((EKSComponent)((Object)component)).setAccessKey((String)EKSComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((EKSComponent)((Object)component)).setSecretKey((String)EKSComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((EKSComponent)((Object)component)).setRegion((String)EKSComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((EKSComponent)((Object)component)).setBasicPropertyBinding((Boolean)EKSComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((EKSComponent)((Object)component)).setLazyStartProducer((Boolean)EKSComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((EKSComponent)((Object)component)).setBridgeErrorHandler((Boolean)EKSComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

