/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.eks;

import com.amazonaws.services.eks.AmazonEKS;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.eks.EKSComponentVerifierExtension;
import org.apache.camel.component.aws.eks.EKSConfiguration;
import org.apache.camel.component.aws.eks.EKSEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-eks")
public class EKSComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private EKSConfiguration configuration;

    public EKSComponent() {
        this(null);
    }

    public EKSComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new EKSComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        EKSConfiguration configuration = this.configuration != null ? this.configuration.copy() : new EKSConfiguration();
        EKSEndpoint endpoint = new EKSEndpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getEksClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon eks client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public EKSConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EKSConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(EKSConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonEKS.class);
        if (clients.size() == 1) {
            configuration.setEksClient((AmazonEKS)clients.stream().findFirst().get());
        }
    }
}

