/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.eks;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.eks.AmazonEKS;
import com.amazonaws.services.eks.AmazonEKSClientBuilder;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.eks.EKSConfiguration;
import org.apache.camel.component.aws.eks.EKSProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.0.0", scheme="aws-eks", title="AWS Elastic Kubernetes Service (EKS)", syntax="aws-eks:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT})
public class EKSEndpoint
extends ScheduledPollEndpoint {
    private AmazonEKS eksClient;
    @UriParam
    private EKSConfiguration configuration;

    public EKSEndpoint(String uri, Component component, EKSConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new EKSProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.eksClient = this.configuration.getEksClient() != null ? this.configuration.getEksClient() : this.createEKSClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getEksClient()) && this.eksClient != null) {
            this.eksClient.shutdown();
        }
        super.doStop();
    }

    public EKSConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonEKS getEksClient() {
        return this.eksClient;
    }

    AmazonEKS createEKSClient() {
        AmazonEKS client = null;
        ClientConfiguration clientConfiguration = null;
        AmazonEKSClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyProtocol(this.configuration.getProxyProtocol());
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonEKSClientBuilder)((AmazonEKSClientBuilder)AmazonEKSClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonEKSClientBuilder)AmazonEKSClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonEKSClientBuilder.standard() : (AmazonEKSClientBuilder)AmazonEKSClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonEKSClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        client = (AmazonEKS)clientBuilder.build();
        return client;
    }
}

