/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.eks;

import com.amazonaws.Protocol;
import com.amazonaws.services.eks.AmazonEKS;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.eks.EKSEndpoint;
import org.apache.camel.component.aws.eks.EKSOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class EKSEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        EKSEndpoint target = (EKSEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                target.getConfiguration().setAccessKey((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                target.getConfiguration().setAutoDiscoverClient((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "eksclient": 
            case "eksClient": {
                target.getConfiguration().setEksClient((AmazonEKS)EKSEndpointConfigurer.property((CamelContext)camelContext, AmazonEKS.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                target.getConfiguration().setOperation((EKSOperations)((Object)EKSEndpointConfigurer.property((CamelContext)camelContext, EKSOperations.class, (Object)value)));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                target.getConfiguration().setProxyHost((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                target.getConfiguration().setProxyPort((Integer)EKSEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                target.getConfiguration().setProxyProtocol((Protocol)EKSEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                target.getConfiguration().setRegion((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                target.getConfiguration().setSecretKey((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        EKSEndpoint target = (EKSEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return target.getConfiguration().getAccessKey();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return target.getConfiguration().isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "eksclient": 
            case "eksClient": {
                return target.getConfiguration().getEksClient();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return target.getConfiguration().getOperation();
            }
            case "proxyhost": 
            case "proxyHost": {
                return target.getConfiguration().getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return target.getConfiguration().getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return target.getConfiguration().getProxyProtocol();
            }
            case "region": {
                return target.getConfiguration().getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return target.getConfiguration().getSecretKey();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("label", String.class);
        map.put("autoDiscoverClient", Boolean.TYPE);
        map.put("accessKey", String.class);
        map.put("eksClient", AmazonEKS.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("operation", EKSOperations.class);
        map.put("proxyHost", String.class);
        map.put("proxyPort", Integer.class);
        map.put("proxyProtocol", Protocol.class);
        map.put("region", String.class);
        map.put("secretKey", String.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

