/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.iam;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest;
import com.amazonaws.services.identitymanagement.model.AddUserToGroupResult;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyResult;
import com.amazonaws.services.identitymanagement.model.CreateGroupRequest;
import com.amazonaws.services.identitymanagement.model.CreateGroupResult;
import com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.amazonaws.services.identitymanagement.model.CreateUserResult;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyResult;
import com.amazonaws.services.identitymanagement.model.DeleteGroupRequest;
import com.amazonaws.services.identitymanagement.model.DeleteGroupResult;
import com.amazonaws.services.identitymanagement.model.DeleteUserRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserResult;
import com.amazonaws.services.identitymanagement.model.GetUserRequest;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysResult;
import com.amazonaws.services.identitymanagement.model.ListGroupsResult;
import com.amazonaws.services.identitymanagement.model.ListUsersResult;
import com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest;
import com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupResult;
import com.amazonaws.services.identitymanagement.model.StatusType;
import com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.UpdateAccessKeyResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.iam.IAMConfiguration;
import org.apache.camel.component.aws.iam.IAMEndpoint;
import org.apache.camel.component.aws.iam.IAMOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class IAMProducer
extends DefaultProducer {
    private transient String iamProducerToString;

    public IAMProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listAccessKeys: {
                this.listAccessKeys(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case createAccessKey: {
                this.createAccessKey(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case deleteAccessKey: {
                this.deleteAccessKey(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case updateAccessKey: {
                this.updateAccessKey(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case createUser: {
                this.createUser(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case deleteUser: {
                this.deleteUser(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case getUser: {
                this.getUser(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case listUsers: {
                this.listUsers(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case createGroup: {
                this.createGroup(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case deleteGroup: {
                this.deleteGroup(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case listGroups: {
                this.listGroups(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case addUserToGroup: {
                this.addUserToGroup(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case removeUserFromGroup: {
                this.removeUserFromGroup(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private IAMOperations determineOperation(Exchange exchange) {
        IAMOperations operation = (IAMOperations)((Object)exchange.getIn().getHeader("CamelAwsIAMOperation", IAMOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected IAMConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.iamProducerToString == null) {
            this.iamProducerToString = "IAMProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.iamProducerToString;
    }

    public IAMEndpoint getEndpoint() {
        return (IAMEndpoint)super.getEndpoint();
    }

    private void listAccessKeys(AmazonIdentityManagement iamClient, Exchange exchange) {
        ListAccessKeysResult result;
        try {
            result = iamClient.listAccessKeys();
        }
        catch (AmazonServiceException ase) {
            this.log.trace("List Access Keys command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createUser(AmazonIdentityManagement iamClient, Exchange exchange) {
        CreateUserResult result;
        CreateUserRequest request = new CreateUserRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            throw new IllegalArgumentException("User Name must be specified");
        }
        String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
        request.withUserName(userName);
        try {
            result = iamClient.createUser(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Create user command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteUser(AmazonIdentityManagement iamClient, Exchange exchange) {
        DeleteUserResult result;
        DeleteUserRequest request = new DeleteUserRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            throw new IllegalArgumentException("User Name must be specified");
        }
        String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
        request.withUserName(userName);
        try {
            result = iamClient.deleteUser(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Delete user command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void getUser(AmazonIdentityManagement iamClient, Exchange exchange) {
        GetUserResult result;
        GetUserRequest request = new GetUserRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            throw new IllegalArgumentException("User Name must be specified");
        }
        String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
        request.withUserName(userName);
        try {
            result = iamClient.getUser(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("get user command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listUsers(AmazonIdentityManagement iamClient, Exchange exchange) {
        ListUsersResult result;
        try {
            result = iamClient.listUsers();
        }
        catch (AmazonServiceException ase) {
            this.log.trace("List users command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createAccessKey(AmazonIdentityManagement iamClient, Exchange exchange) {
        CreateAccessKeyResult result;
        CreateAccessKeyRequest request = new CreateAccessKeyRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            request.withUserName(userName);
        }
        try {
            result = iamClient.createAccessKey(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Create Access Key command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteAccessKey(AmazonIdentityManagement iamClient, Exchange exchange) {
        DeleteAccessKeyResult result;
        DeleteAccessKeyRequest request = new DeleteAccessKeyRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String accessKeyId = (String)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID", String.class);
        request.withAccessKeyId(accessKeyId);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            request.withUserName(userName);
        }
        try {
            result = iamClient.deleteAccessKey(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Delete Access Key command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void updateAccessKey(AmazonIdentityManagement iamClient, Exchange exchange) {
        UpdateAccessKeyResult result;
        UpdateAccessKeyRequest request = new UpdateAccessKeyRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String accessKeyId = (String)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID", String.class);
        request.withAccessKeyId(accessKeyId);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMAccessKeyStatus"))) {
            throw new IllegalArgumentException("Access Key status must be specified");
        }
        String status = (String)exchange.getIn().getHeader("CamelAwsIAMAccessKeyStatus", String.class);
        request.withStatus(StatusType.fromValue((String)status));
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            request.withUserName(userName);
        }
        try {
            result = iamClient.updateAccessKey(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Update Access Key command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createGroup(AmazonIdentityManagement iamClient, Exchange exchange) {
        CreateGroupResult result;
        CreateGroupRequest request = new CreateGroupRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMGroupName"))) {
            throw new IllegalArgumentException("Group Name must be specified");
        }
        String groupName = (String)exchange.getIn().getHeader("CamelAwsIAMGroupName", String.class);
        request.withGroupName(groupName);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMGroupPath"))) {
            String groupPath = (String)exchange.getIn().getHeader("CamelAwsIAMGroupPath", String.class);
            request.withPath(groupPath);
        }
        try {
            result = iamClient.createGroup(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Create Group command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteGroup(AmazonIdentityManagement iamClient, Exchange exchange) {
        DeleteGroupResult result;
        DeleteGroupRequest request = new DeleteGroupRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMGroupName"))) {
            throw new IllegalArgumentException("Group Name must be specified");
        }
        String groupName = (String)exchange.getIn().getHeader("CamelAwsIAMGroupName", String.class);
        request.withGroupName(groupName);
        try {
            result = iamClient.deleteGroup(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Delete Group command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listGroups(AmazonIdentityManagement iamClient, Exchange exchange) {
        ListGroupsResult result;
        try {
            result = iamClient.listGroups();
        }
        catch (AmazonServiceException ase) {
            this.log.trace("List Groups command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void addUserToGroup(AmazonIdentityManagement iamClient, Exchange exchange) {
        AddUserToGroupResult result;
        AddUserToGroupRequest request = new AddUserToGroupRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMGroupName"))) {
            throw new IllegalArgumentException("Group Name must be specified");
        }
        String groupName = (String)exchange.getIn().getHeader("CamelAwsIAMGroupName", String.class);
        request.withGroupName(groupName);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            throw new IllegalArgumentException("User Name must be specified");
        }
        String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
        request.withUserName(userName);
        try {
            result = iamClient.addUserToGroup(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Add User To Group command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void removeUserFromGroup(AmazonIdentityManagement iamClient, Exchange exchange) {
        RemoveUserFromGroupResult result;
        RemoveUserFromGroupRequest request = new RemoveUserFromGroupRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMGroupName"))) {
            throw new IllegalArgumentException("Group Name must be specified");
        }
        String groupName = (String)exchange.getIn().getHeader("CamelAwsIAMGroupName", String.class);
        request.withGroupName(groupName);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            throw new IllegalArgumentException("User Name must be specified");
        }
        String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
        request.withUserName(userName);
        try {
            result = iamClient.removeUserFromGroup(request);
        }
        catch (AmazonServiceException ase) {
            this.log.trace("Remove User From Group command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = IAMProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }
}

