/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.firehose;

import com.amazonaws.Protocol;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.firehose.KinesisFirehoseComponent;
import org.apache.camel.component.aws.firehose.KinesisFirehoseConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class KinesisFirehoseComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private KinesisFirehoseConfiguration getOrCreateConfiguration(KinesisFirehoseComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new KinesisFirehoseConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        KinesisFirehoseComponent target = (KinesisFirehoseComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonkinesisfirehoseclient": 
            case "amazonKinesisFirehoseClient": {
                this.getOrCreateConfiguration(target).setAmazonKinesisFirehoseClient((AmazonKinesisFirehose)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, AmazonKinesisFirehose.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((KinesisFirehoseConfiguration)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, KinesisFirehoseConfiguration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)KinesisFirehoseComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonKinesisFirehoseClient", AmazonKinesisFirehose.class);
        answer.put("autoDiscoverClient", Boolean.TYPE);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("configuration", KinesisFirehoseConfiguration.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        KinesisFirehoseComponent target = (KinesisFirehoseComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonkinesisfirehoseclient": 
            case "amazonKinesisFirehoseClient": {
                return this.getOrCreateConfiguration(target).getAmazonKinesisFirehoseClient();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
        }
        return null;
    }
}

