/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kinesis;

import com.amazonaws.Protocol;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.kinesis.KinesisComponent;
import org.apache.camel.component.aws.kinesis.KinesisConfiguration;
import org.apache.camel.component.aws.kinesis.KinesisShardClosedStrategyEnum;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class KinesisComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private KinesisConfiguration getOrCreateConfiguration(KinesisComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new KinesisConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        KinesisComponent target = (KinesisComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)KinesisComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonkinesisclient": 
            case "amazonKinesisClient": {
                this.getOrCreateConfiguration(target).setAmazonKinesisClient((AmazonKinesis)KinesisComponentConfigurer.property((CamelContext)camelContext, AmazonKinesis.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)KinesisComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)KinesisComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)KinesisComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((KinesisConfiguration)KinesisComponentConfigurer.property((CamelContext)camelContext, KinesisConfiguration.class, (Object)value));
                return true;
            }
            case "iteratortype": 
            case "iteratorType": {
                this.getOrCreateConfiguration(target).setIteratorType((ShardIteratorType)KinesisComponentConfigurer.property((CamelContext)camelContext, ShardIteratorType.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)KinesisComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxresultsperrequest": 
            case "maxResultsPerRequest": {
                this.getOrCreateConfiguration(target).setMaxResultsPerRequest((Integer)KinesisComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)KinesisComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)KinesisComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)KinesisComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)KinesisComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)KinesisComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sequencenumber": 
            case "sequenceNumber": {
                this.getOrCreateConfiguration(target).setSequenceNumber((String)KinesisComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "shardclosed": 
            case "shardClosed": {
                this.getOrCreateConfiguration(target).setShardClosed((KinesisShardClosedStrategyEnum)((Object)KinesisComponentConfigurer.property((CamelContext)camelContext, KinesisShardClosedStrategyEnum.class, (Object)value)));
                return true;
            }
            case "shardid": 
            case "shardId": {
                this.getOrCreateConfiguration(target).setShardId((String)KinesisComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        KinesisComponent target = (KinesisComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonkinesisclient": 
            case "amazonKinesisClient": {
                return this.getOrCreateConfiguration(target).getAmazonKinesisClient();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "iteratortype": 
            case "iteratorType": {
                return this.getOrCreateConfiguration(target).getIteratorType();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxresultsperrequest": 
            case "maxResultsPerRequest": {
                return this.getOrCreateConfiguration(target).getMaxResultsPerRequest();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "sequencenumber": 
            case "sequenceNumber": {
                return this.getOrCreateConfiguration(target).getSequenceNumber();
            }
            case "shardclosed": 
            case "shardClosed": {
                return this.getOrCreateConfiguration(target).getShardClosed();
            }
            case "shardid": 
            case "shardId": {
                return this.getOrCreateConfiguration(target).getShardId();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("amazonKinesisClient", AmazonKinesis.class);
        map.put("autoDiscoverClient", Boolean.TYPE);
        map.put("configuration", KinesisConfiguration.class);
        map.put("proxyHost", String.class);
        map.put("proxyPort", Integer.class);
        map.put("proxyProtocol", Protocol.class);
        map.put("region", String.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("iteratorType", ShardIteratorType.class);
        map.put("maxResultsPerRequest", Integer.TYPE);
        map.put("sequenceNumber", String.class);
        map.put("shardClosed", KinesisShardClosedStrategyEnum.class);
        map.put("shardId", String.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("accessKey", String.class);
        map.put("secretKey", String.class);
        ALL_OPTIONS = map;
    }
}

