/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.firehose;

import com.amazonaws.Protocol;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class KinesisFirehoseConfiguration
implements Cloneable {
    @UriPath(description="Name of the stream")
    @Metadata(required=true)
    private String streamName;
    @UriParam(label="security", secret=true, description="Amazon AWS Access Key")
    private String accessKey;
    @UriParam(label="security", secret=true, description="Amazon AWS Secret Key")
    private String secretKey;
    @UriParam(description="The region in which Kinesis client needs to work. When using this parameter, the configuration will expect the capitalized name of the region (for example AP_EAST_1)You'll need to use the name Regions.EU_WEST_1.name()")
    private String region;
    @UriParam(description="Amazon Kinesis Firehose client to use for all requests for this endpoint")
    private AmazonKinesisFirehose amazonKinesisFirehoseClient;
    @UriParam(enums="HTTP,HTTPS", defaultValue="HTTPS", description="To define a proxy protocol when instantiating the Kinesis Firehose client")
    private Protocol proxyProtocol = Protocol.HTTPS;
    @UriParam(description="To define a proxy host when instantiating the Kinesis Firehose client")
    private String proxyHost;
    @UriParam(description="To define a proxy port when instantiating the Kinesis Firehose client")
    private Integer proxyPort;
    @UriParam(label="common", defaultValue="true", description="Setting the autoDiscoverClient mechanism, if true, the component will  look for a client instance in the registry automatically otherwise it will skip that checking")
    private boolean autoDiscoverClient = true;

    public void setAmazonKinesisFirehoseClient(AmazonKinesisFirehose client) {
        this.amazonKinesisFirehoseClient = client;
    }

    public AmazonKinesisFirehose getAmazonKinesisFirehoseClient() {
        return this.amazonKinesisFirehoseClient;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isAutoDiscoverClient() {
        return this.autoDiscoverClient;
    }

    public void setAutoDiscoverClient(boolean autoDiscoverClient) {
        this.autoDiscoverClient = autoDiscoverClient;
    }

    public KinesisFirehoseConfiguration copy() {
        try {
            return (KinesisFirehoseConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

