/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kinesis;

import com.amazonaws.services.kinesis.AmazonKinesis;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.kinesis.KinesisComponentVerifierExtension;
import org.apache.camel.component.aws.kinesis.KinesisConfiguration;
import org.apache.camel.component.aws.kinesis.KinesisEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="aws-kinesis")
public class KinesisComponent
extends DefaultComponent {
    @Metadata
    private KinesisConfiguration configuration = new KinesisConfiguration();

    public KinesisComponent() {
        this(null);
    }

    public KinesisComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new KinesisComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KinesisConfiguration configuration = this.configuration != null ? this.configuration.copy() : new KinesisConfiguration();
        configuration.setStreamName(remaining);
        KinesisEndpoint endpoint = new KinesisEndpoint(uri, configuration, this);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration);
        }
        if (configuration.getAmazonKinesisClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonKinesisClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public KinesisConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KinesisConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(KinesisConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonKinesis.class);
        if (clients.size() == 1) {
            configuration.setAmazonKinesisClient((AmazonKinesis)clients.stream().findFirst().get());
        }
    }
}

