/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kms;

import com.amazonaws.Protocol;
import com.amazonaws.services.kms.AWSKMS;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.kms.KMSEndpoint;
import org.apache.camel.component.aws.kms.KMSOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class KMSEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return KMSEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return KMSEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "kmsClient": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setKmsClient((AWSKMS)KMSEndpointConfigurer.property((CamelContext)camelContext, AWSKMS.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)KMSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)KMSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setOperation((KMSOperations)((Object)KMSEndpointConfigurer.property((CamelContext)camelContext, KMSOperations.class, (Object)value)));
                return true;
            }
            case "proxyProtocol": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)KMSEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)KMSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)KMSEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)KMSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((KMSEndpoint)((Object)endpoint)).setStartScheduler((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((KMSEndpoint)((Object)endpoint)).setInitialDelay((Long)KMSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((KMSEndpoint)((Object)endpoint)).setDelay((Long)KMSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((KMSEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)KMSEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((KMSEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((KMSEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)KMSEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((KMSEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)KMSEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((KMSEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((KMSEndpoint)((Object)endpoint)).setGreedy((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((KMSEndpoint)((Object)endpoint)).setScheduler((String)KMSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((KMSEndpoint)((Object)endpoint)).setSchedulerProperties((Map)KMSEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((KMSEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)KMSEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((KMSEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)KMSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((KMSEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)KMSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((KMSEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)KMSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatCount": {
                ((KMSEndpoint)((Object)endpoint)).setRepeatCount((Long)KMSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((KMSEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((KMSEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((KMSEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)KMSEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((KMSEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)KMSEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((KMSEndpoint)((Object)endpoint)).setSynchronous((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((KMSEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "kmsclient": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setKmsClient((AWSKMS)KMSEndpointConfigurer.property((CamelContext)camelContext, AWSKMS.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)KMSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)KMSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setOperation((KMSOperations)((Object)KMSEndpointConfigurer.property((CamelContext)camelContext, KMSOperations.class, (Object)value)));
                return true;
            }
            case "proxyprotocol": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)KMSEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)KMSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)KMSEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((KMSEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)KMSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((KMSEndpoint)((Object)endpoint)).setStartScheduler((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((KMSEndpoint)((Object)endpoint)).setInitialDelay((Long)KMSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((KMSEndpoint)((Object)endpoint)).setDelay((Long)KMSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((KMSEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)KMSEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((KMSEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((KMSEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)KMSEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((KMSEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)KMSEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((KMSEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((KMSEndpoint)((Object)endpoint)).setGreedy((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((KMSEndpoint)((Object)endpoint)).setScheduler((String)KMSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((KMSEndpoint)((Object)endpoint)).setSchedulerProperties((Map)KMSEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((KMSEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)KMSEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((KMSEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)KMSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((KMSEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)KMSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((KMSEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)KMSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatcount": {
                ((KMSEndpoint)((Object)endpoint)).setRepeatCount((Long)KMSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((KMSEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((KMSEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((KMSEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)KMSEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((KMSEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)KMSEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((KMSEndpoint)((Object)endpoint)).setSynchronous((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((KMSEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)KMSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

