/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kms;

import com.amazonaws.services.kms.AWSKMS;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.kms.KMSComponentVerifierExtension;
import org.apache.camel.component.aws.kms.KMSConfiguration;
import org.apache.camel.component.aws.kms.KMSEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-kms")
public class KMSComponent
extends DefaultComponent {
    @Metadata
    private KMSConfiguration configuration = new KMSConfiguration();

    public KMSComponent() {
        this(null);
    }

    public KMSComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new KMSComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KMSConfiguration configuration = this.configuration != null ? this.configuration.copy() : new KMSConfiguration();
        KMSEndpoint endpoint = new KMSEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration);
        }
        if (configuration.getKmsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon kms client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public KMSConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KMSConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(KMSConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AWSKMS.class);
        if (clients.size() == 1) {
            configuration.setKmsClient((AWSKMS)clients.stream().findFirst().get());
        }
    }
}

