/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.aws.lambda.LambdaEndpoint;
import org.apache.camel.component.aws.lambda.LambdaOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class LambdaEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return LambdaEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return LambdaEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "operation": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setOperation((LambdaOperations)((Object)LambdaEndpointConfigurer.property((CamelContext)camelContext, LambdaOperations.class, (Object)value)));
                return true;
            }
            case "accessKey": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)LambdaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)LambdaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)LambdaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)LambdaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)LambdaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "awsLambdaClient": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setAwsLambdaClient((AWSLambda)LambdaEndpointConfigurer.property((CamelContext)camelContext, AWSLambda.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((LambdaEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)LambdaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((LambdaEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)LambdaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((LambdaEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)LambdaEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((LambdaEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)LambdaEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((LambdaEndpoint)((Object)endpoint)).setSynchronous((Boolean)LambdaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((LambdaEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)LambdaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "operation": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setOperation((LambdaOperations)((Object)LambdaEndpointConfigurer.property((CamelContext)camelContext, LambdaOperations.class, (Object)value)));
                return true;
            }
            case "accesskey": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)LambdaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)LambdaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)LambdaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)LambdaEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)LambdaEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "awslambdaclient": {
                ((LambdaEndpoint)((Object)endpoint)).getConfiguration().setAwsLambdaClient((AWSLambda)LambdaEndpointConfigurer.property((CamelContext)camelContext, AWSLambda.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((LambdaEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)LambdaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((LambdaEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)LambdaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((LambdaEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)LambdaEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((LambdaEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)LambdaEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((LambdaEndpoint)((Object)endpoint)).setSynchronous((Boolean)LambdaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((LambdaEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)LambdaEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

