/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.msk;

import com.amazonaws.services.kafka.AWSKafka;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.msk.MSKComponentVerifierExtension;
import org.apache.camel.component.aws.msk.MSKConfiguration;
import org.apache.camel.component.aws.msk.MSKEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-msk")
public class MSKComponent
extends DefaultComponent {
    @Metadata
    private MSKConfiguration configuration = new MSKConfiguration();

    public MSKComponent() {
        this(null);
    }

    public MSKComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new MSKComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MSKConfiguration configuration = this.configuration != null ? this.configuration.copy() : new MSKConfiguration();
        MSKEndpoint endpoint = new MSKEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration);
        }
        if (configuration.getMskClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon msk client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public MSKConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MSKConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(MSKConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AWSKafka.class);
        if (clients.size() == 1) {
            configuration.setMskClient((AWSKafka)clients.stream().findFirst().get());
        }
    }
}

