/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.S3Endpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class S3Consumer
extends ScheduledBatchPollingConsumer {
    private String marker;
    private transient String s3ConsumerToString;

    public S3Consumer(S3Endpoint endpoint, Processor processor) throws NoFactoryAvailableException {
        super((Endpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        Queue<Exchange> exchanges;
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        String fileName = this.getConfiguration().getFileName();
        String bucketName = this.getConfiguration().getBucketName();
        if (fileName != null) {
            this.log.trace("Getting object in bucket [{}] with file name [{}]...", (Object)bucketName, (Object)fileName);
            S3Object s3Object = this.getAmazonS3Client().getObject(new GetObjectRequest(bucketName, fileName));
            exchanges = this.createExchanges(s3Object);
        } else {
            ObjectListing listObjects;
            this.log.trace("Queueing objects in bucket [{}]...", (Object)bucketName);
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
            listObjectsRequest.setBucketName(bucketName);
            listObjectsRequest.setPrefix(this.getConfiguration().getPrefix());
            if (this.maxMessagesPerPoll > 0) {
                listObjectsRequest.setMaxKeys(Integer.valueOf(this.maxMessagesPerPoll));
            }
            if (this.marker != null) {
                this.log.trace("Resuming from marker: {}", (Object)this.marker);
                listObjectsRequest.setMarker(this.marker);
            }
            if ((listObjects = this.getAmazonS3Client().listObjects(listObjectsRequest)).isTruncated()) {
                this.marker = listObjects.getNextMarker();
                this.log.trace("Returned list is truncated, so setting next marker: {}", (Object)this.marker);
            } else {
                this.marker = null;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Found {} objects in bucket [{}]...", (Object)listObjects.getObjectSummaries().size(), (Object)bucketName);
            }
            exchanges = this.createExchanges(listObjects.getObjectSummaries());
        }
        return this.processBatch(CastUtils.cast(exchanges));
    }

    protected Queue<Exchange> createExchanges(S3Object s3Object) {
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        Exchange exchange = this.getEndpoint().createExchange(s3Object);
        answer.add(exchange);
        return answer;
    }

    protected Queue<Exchange> createExchanges(List<S3ObjectSummary> s3ObjectSummaries) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received {} messages in this poll", (Object)s3ObjectSummaries.size());
        }
        ArrayList<S3Object> s3Objects = new ArrayList<S3Object>();
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        try {
            for (S3ObjectSummary s3ObjectSummary : s3ObjectSummaries) {
                S3Object s3Object = this.getAmazonS3Client().getObject(s3ObjectSummary.getBucketName(), s3ObjectSummary.getKey());
                s3Objects.add(s3Object);
                Exchange exchange = this.getEndpoint().createExchange(s3Object);
                answer.add(exchange);
            }
        }
        catch (Throwable e) {
            this.log.warn("Error getting S3Object due: {}", (Object)e.getMessage(), (Object)e);
            s3Objects.forEach(IOHelper::close);
            throw e;
        }
        return answer;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            final Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            exchange.addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    S3Consumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    S3Consumer.this.processRollback(exchange);
                }

                public String toString() {
                    return "S3ConsumerOnCompletion";
                }
            });
            this.log.trace("Processing exchange [{}]...", (Object)exchange);
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    S3Consumer.this.log.trace("Processing exchange [{}] done.", (Object)exchange);
                }
            });
        }
        return total;
    }

    protected void processCommit(Exchange exchange) {
        try {
            if (this.getConfiguration().isDeleteAfterRead()) {
                String bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
                String key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
                this.log.trace("Deleting object from bucket {} with key {}...", (Object)bucketName, (Object)key);
                this.getAmazonS3Client().deleteObject(bucketName, key);
                this.log.trace("Deleted object from bucket {} with key {}...", (Object)bucketName, (Object)key);
            }
        }
        catch (AmazonClientException e) {
            this.getExceptionHandler().handleException("Error occurred during deleting object. This exception is ignored.", exchange, (Throwable)e);
        }
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            this.log.warn("Exchange failed, so rolling back message status: {}", (Object)exchange, (Object)cause);
        } else {
            this.log.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    protected S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected AmazonS3 getAmazonS3Client() {
        return this.getEndpoint().getS3Client();
    }

    public S3Endpoint getEndpoint() {
        return (S3Endpoint)super.getEndpoint();
    }

    public String toString() {
        if (this.s3ConsumerToString == null) {
            this.s3ConsumerToString = "S3Consumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.s3ConsumerToString;
    }
}

