/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import com.amazonaws.Protocol;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.s3.S3Component;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.S3Operations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class S3ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private S3Configuration getOrCreateConfiguration(S3Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new S3Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        S3Component target = (S3Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceleratemodeenabled": 
            case "accelerateModeEnabled": {
                this.getOrCreateConfiguration(target).setAccelerateModeEnabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazons3client": 
            case "amazonS3Client": {
                this.getOrCreateConfiguration(target).setAmazonS3Client((AmazonS3)S3ComponentConfigurer.property((CamelContext)camelContext, AmazonS3.class, (Object)value));
                return true;
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                this.getOrCreateConfiguration(target).setAutoCreateBucket((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autoclosebody": 
            case "autocloseBody": {
                this.getOrCreateConfiguration(target).setAutocloseBody((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "awskmskeyid": 
            case "awsKMSKeyId": {
                this.getOrCreateConfiguration(target).setAwsKMSKeyId((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "chunkedencodingdisabled": 
            case "chunkedEncodingDisabled": {
                this.getOrCreateConfiguration(target).setChunkedEncodingDisabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((S3Configuration)S3ComponentConfigurer.property((CamelContext)camelContext, S3Configuration.class, (Object)value));
                return true;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                this.getOrCreateConfiguration(target).setDeleteAfterRead((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                this.getOrCreateConfiguration(target).setDeleteAfterWrite((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delimiter": {
                this.getOrCreateConfiguration(target).setDelimiter((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "donefilename": 
            case "doneFileName": {
                this.getOrCreateConfiguration(target).setDoneFileName((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "dualstackenabled": 
            case "dualstackEnabled": {
                this.getOrCreateConfiguration(target).setDualstackEnabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "encryptionmaterials": 
            case "encryptionMaterials": {
                this.getOrCreateConfiguration(target).setEncryptionMaterials((EncryptionMaterials)S3ComponentConfigurer.property((CamelContext)camelContext, EncryptionMaterials.class, (Object)value));
                return true;
            }
            case "endpointconfiguration": 
            case "endpointConfiguration": {
                this.getOrCreateConfiguration(target).setEndpointConfiguration((AwsClientBuilder.EndpointConfiguration)S3ComponentConfigurer.property((CamelContext)camelContext, AwsClientBuilder.EndpointConfiguration.class, (Object)value));
                return true;
            }
            case "filename": 
            case "fileName": {
                this.getOrCreateConfiguration(target).setFileName((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "forceglobalbucketaccessenabled": 
            case "forceGlobalBucketAccessEnabled": {
                this.getOrCreateConfiguration(target).setForceGlobalBucketAccessEnabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "includebody": 
            case "includeBody": {
                this.getOrCreateConfiguration(target).setIncludeBody((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keyname": 
            case "keyName": {
                this.getOrCreateConfiguration(target).setKeyName((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "multipartupload": 
            case "multiPartUpload": {
                this.getOrCreateConfiguration(target).setMultiPartUpload((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((S3Operations)((Object)S3ComponentConfigurer.property((CamelContext)camelContext, S3Operations.class, (Object)value)));
                return true;
            }
            case "partsize": 
            case "partSize": {
                this.getOrCreateConfiguration(target).setPartSize((Long)S3ComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "pathstyleaccess": 
            case "pathStyleAccess": {
                this.getOrCreateConfiguration(target).setPathStyleAccess((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "payloadsigningenabled": 
            case "payloadSigningEnabled": {
                this.getOrCreateConfiguration(target).setPayloadSigningEnabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "policy": {
                this.getOrCreateConfiguration(target).setPolicy((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "prefix": {
                this.getOrCreateConfiguration(target).setPrefix((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)S3ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)S3ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serversideencryption": 
            case "serverSideEncryption": {
                this.getOrCreateConfiguration(target).setServerSideEncryption((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "storageclass": 
            case "storageClass": {
                this.getOrCreateConfiguration(target).setStorageClass((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "useawskms": 
            case "useAwsKMS": {
                this.getOrCreateConfiguration(target).setUseAwsKMS((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useencryption": 
            case "useEncryption": {
                this.getOrCreateConfiguration(target).setUseEncryption((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useiamcredentials": 
            case "useIAMCredentials": {
                this.getOrCreateConfiguration(target).setUseIAMCredentials((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceleratemodeenabled": 
            case "accelerateModeEnabled": {
                return Boolean.TYPE;
            }
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "amazons3client": 
            case "amazonS3Client": {
                return AmazonS3.class;
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return Boolean.TYPE;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return Boolean.TYPE;
            }
            case "autoclosebody": 
            case "autocloseBody": {
                return Boolean.TYPE;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "awskmskeyid": 
            case "awsKMSKeyId": {
                return String.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "chunkedencodingdisabled": 
            case "chunkedEncodingDisabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return S3Configuration.class;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return Boolean.TYPE;
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                return Boolean.TYPE;
            }
            case "delimiter": {
                return String.class;
            }
            case "donefilename": 
            case "doneFileName": {
                return String.class;
            }
            case "dualstackenabled": 
            case "dualstackEnabled": {
                return Boolean.TYPE;
            }
            case "encryptionmaterials": 
            case "encryptionMaterials": {
                return EncryptionMaterials.class;
            }
            case "endpointconfiguration": 
            case "endpointConfiguration": {
                return AwsClientBuilder.EndpointConfiguration.class;
            }
            case "filename": 
            case "fileName": {
                return String.class;
            }
            case "forceglobalbucketaccessenabled": 
            case "forceGlobalBucketAccessEnabled": {
                return Boolean.TYPE;
            }
            case "includebody": 
            case "includeBody": {
                return Boolean.TYPE;
            }
            case "keyname": 
            case "keyName": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "multipartupload": 
            case "multiPartUpload": {
                return Boolean.TYPE;
            }
            case "operation": {
                return S3Operations.class;
            }
            case "partsize": 
            case "partSize": {
                return Long.TYPE;
            }
            case "pathstyleaccess": 
            case "pathStyleAccess": {
                return Boolean.TYPE;
            }
            case "payloadsigningenabled": 
            case "payloadSigningEnabled": {
                return Boolean.TYPE;
            }
            case "policy": {
                return String.class;
            }
            case "prefix": {
                return String.class;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return Protocol.class;
            }
            case "region": {
                return String.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "serversideencryption": 
            case "serverSideEncryption": {
                return String.class;
            }
            case "storageclass": 
            case "storageClass": {
                return String.class;
            }
            case "useawskms": 
            case "useAwsKMS": {
                return Boolean.TYPE;
            }
            case "useencryption": 
            case "useEncryption": {
                return Boolean.TYPE;
            }
            case "useiamcredentials": 
            case "useIAMCredentials": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        S3Component target = (S3Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceleratemodeenabled": 
            case "accelerateModeEnabled": {
                return this.getOrCreateConfiguration(target).isAccelerateModeEnabled();
            }
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazons3client": 
            case "amazonS3Client": {
                return this.getOrCreateConfiguration(target).getAmazonS3Client();
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return this.getOrCreateConfiguration(target).isAutoCreateBucket();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "autoclosebody": 
            case "autocloseBody": {
                return this.getOrCreateConfiguration(target).isAutocloseBody();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "awskmskeyid": 
            case "awsKMSKeyId": {
                return this.getOrCreateConfiguration(target).getAwsKMSKeyId();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "chunkedencodingdisabled": 
            case "chunkedEncodingDisabled": {
                return this.getOrCreateConfiguration(target).isChunkedEncodingDisabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return this.getOrCreateConfiguration(target).isDeleteAfterRead();
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                return this.getOrCreateConfiguration(target).isDeleteAfterWrite();
            }
            case "delimiter": {
                return this.getOrCreateConfiguration(target).getDelimiter();
            }
            case "donefilename": 
            case "doneFileName": {
                return this.getOrCreateConfiguration(target).getDoneFileName();
            }
            case "dualstackenabled": 
            case "dualstackEnabled": {
                return this.getOrCreateConfiguration(target).isDualstackEnabled();
            }
            case "encryptionmaterials": 
            case "encryptionMaterials": {
                return this.getOrCreateConfiguration(target).getEncryptionMaterials();
            }
            case "endpointconfiguration": 
            case "endpointConfiguration": {
                return this.getOrCreateConfiguration(target).getEndpointConfiguration();
            }
            case "filename": 
            case "fileName": {
                return this.getOrCreateConfiguration(target).getFileName();
            }
            case "forceglobalbucketaccessenabled": 
            case "forceGlobalBucketAccessEnabled": {
                return this.getOrCreateConfiguration(target).isForceGlobalBucketAccessEnabled();
            }
            case "includebody": 
            case "includeBody": {
                return this.getOrCreateConfiguration(target).isIncludeBody();
            }
            case "keyname": 
            case "keyName": {
                return this.getOrCreateConfiguration(target).getKeyName();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "multipartupload": 
            case "multiPartUpload": {
                return this.getOrCreateConfiguration(target).isMultiPartUpload();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "partsize": 
            case "partSize": {
                return this.getOrCreateConfiguration(target).getPartSize();
            }
            case "pathstyleaccess": 
            case "pathStyleAccess": {
                return this.getOrCreateConfiguration(target).isPathStyleAccess();
            }
            case "payloadsigningenabled": 
            case "payloadSigningEnabled": {
                return this.getOrCreateConfiguration(target).isPayloadSigningEnabled();
            }
            case "policy": {
                return this.getOrCreateConfiguration(target).getPolicy();
            }
            case "prefix": {
                return this.getOrCreateConfiguration(target).getPrefix();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "serversideencryption": 
            case "serverSideEncryption": {
                return this.getOrCreateConfiguration(target).getServerSideEncryption();
            }
            case "storageclass": 
            case "storageClass": {
                return this.getOrCreateConfiguration(target).getStorageClass();
            }
            case "useawskms": 
            case "useAwsKMS": {
                return this.getOrCreateConfiguration(target).isUseAwsKMS();
            }
            case "useencryption": 
            case "useEncryption": {
                return this.getOrCreateConfiguration(target).isUseEncryption();
            }
            case "useiamcredentials": 
            case "useIAMCredentials": {
                return this.getOrCreateConfiguration(target).isUseIAMCredentials();
            }
        }
        return null;
    }
}

