/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.sdb.AbstractSdbCommand;
import org.apache.camel.component.aws.sdb.SdbConfiguration;

public class DomainMetadataCommand
extends AbstractSdbCommand {
    public DomainMetadataCommand(AmazonSimpleDB sdbClient, SdbConfiguration configuration, Exchange exchange) {
        super(sdbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        DomainMetadataRequest request = new DomainMetadataRequest().withDomainName(this.determineDomainName());
        this.log.trace("Sending request [{}] for exchange [{}]...", (Object)request, (Object)this.exchange);
        DomainMetadataResult result = this.sdbClient.domainMetadata(request);
        this.log.trace("Received result [{}]", (Object)result);
        Message msg = DomainMetadataCommand.getMessageForResponse(this.exchange);
        msg.setHeader("CamelAwsSdbTimestamp", (Object)result.getTimestamp());
        msg.setHeader("CamelAwsSdbItemCount", (Object)result.getItemCount());
        msg.setHeader("CamelAwsSdbAttributeNameCount", (Object)result.getAttributeNameCount());
        msg.setHeader("CamelAwsSdbAttributeValueCount", (Object)result.getAttributeValueCount());
        msg.setHeader("CamelAwsSdbAttributeNameSize", (Object)result.getAttributeNamesSizeBytes());
        msg.setHeader("CamelAwsSdbAttributeValueSize", (Object)result.getAttributeValuesSizeBytes());
        msg.setHeader("CamelAwsSdbItemNameSize", (Object)result.getItemNamesSizeBytes());
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

