/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.sdb.SdbComponentVerifierExtension;
import org.apache.camel.component.aws.sdb.SdbConfiguration;
import org.apache.camel.component.aws.sdb.SdbEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-sdb")
public class SdbComponent
extends DefaultComponent {
    public SdbComponent() {
        this(null);
    }

    public SdbComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new SdbComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Domain name must be specified.");
        }
        SdbConfiguration configuration = new SdbConfiguration();
        configuration.setDomainName(remaining);
        SdbEndpoint endpoint = new SdbEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.getAmazonSDBClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonSDBClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }
}

