/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.AmazonSimpleDBClientBuilder;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.NoSuchDomainException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.sdb.SdbConfiguration;
import org.apache.camel.component.aws.sdb.SdbProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.9.0", scheme="aws-sdb", title="AWS SimpleDB", syntax="aws-sdb:domainName", producerOnly=true, category={Category.CLOUD, Category.DATABASE, Category.NOSQL})
public class SdbEndpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SdbEndpoint.class);
    private AmazonSimpleDB sdbClient;
    @UriParam
    private SdbConfiguration configuration;

    public SdbEndpoint(String uri, Component component, SdbConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new SdbProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.sdbClient = this.configuration.getAmazonSDBClient() != null ? this.configuration.getAmazonSDBClient() : this.createSdbClient();
        String domainName = this.getConfiguration().getDomainName();
        LOG.trace("Querying whether domain [{}] already exists...", (Object)domainName);
        try {
            this.sdbClient.domainMetadata(new DomainMetadataRequest(domainName));
            LOG.trace("Domain [{}] already exists", (Object)domainName);
            return;
        }
        catch (NoSuchDomainException ase) {
            LOG.trace("Domain [{}] doesn't exist yet", (Object)domainName);
            LOG.trace("Creating domain [{}]...", (Object)domainName);
            this.sdbClient.createDomain(new CreateDomainRequest(domainName));
            LOG.trace("Domain [{}] created", (Object)domainName);
            return;
        }
    }

    public SdbConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonSimpleDB getSdbClient() {
        return this.sdbClient;
    }

    AmazonSimpleDB createSdbClient() {
        AmazonSimpleDB client = null;
        AmazonSimpleDBClientBuilder clientBuilder = null;
        ClientConfiguration clientConfiguration = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyProtocol(this.configuration.getProxyProtocol());
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonSimpleDBClientBuilder)((AmazonSimpleDBClientBuilder)AmazonSimpleDBClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonSimpleDBClientBuilder)AmazonSimpleDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonSimpleDBClientBuilder.standard() : (AmazonSimpleDBClientBuilder)AmazonSimpleDBClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonSimpleDBClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        client = (AmazonSimpleDB)clientBuilder.build();
        return client;
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

