/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.secretsmanager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Base64;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.annotations.PropertiesFunction;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.vault.AwsVaultConfiguration;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

@PropertiesFunction(value="aws")
public class SecretsManagerPropertiesFunction
extends ServiceSupport
implements org.apache.camel.spi.PropertiesFunction,
CamelContextAware {
    private static final String CAMEL_AWS_VAULT_ACCESS_KEY_ENV = "CAMEL_VAULT_AWS_ACCESS_KEY";
    private static final String CAMEL_AWS_VAULT_SECRET_KEY_ENV = "CAMEL_VAULT_AWS_SECRET_KEY";
    private static final String CAMEL_AWS_VAULT_REGION_ENV = "CAMEL_VAULT_AWS_REGION";
    private static final String CAMEL_AWS_VAULT_USE_DEFAULT_CREDENTIALS_PROVIDER_ENV = "CAMEL_VAULT_AWS_USE_DEFAULT_CREDENTIALS_PROVIDER";
    private CamelContext camelContext;
    private SecretsManagerClient client;

    protected void doStart() throws Exception {
        SecretsManagerClientBuilder clientBuilder;
        AwsVaultConfiguration awsVaultConfiguration;
        super.doStart();
        String accessKey = System.getenv(CAMEL_AWS_VAULT_ACCESS_KEY_ENV);
        String secretKey = System.getenv(CAMEL_AWS_VAULT_SECRET_KEY_ENV);
        String region = System.getenv(CAMEL_AWS_VAULT_REGION_ENV);
        boolean useDefaultCredentialsProvider = Boolean.parseBoolean(System.getenv(CAMEL_AWS_VAULT_USE_DEFAULT_CREDENTIALS_PROVIDER_ENV));
        if (ObjectHelper.isEmpty((Object)accessKey) && ObjectHelper.isEmpty((Object)secretKey) && ObjectHelper.isEmpty((Object)region) && ObjectHelper.isNotEmpty((Object)(awsVaultConfiguration = this.getCamelContext().getVaultConfiguration().aws()))) {
            accessKey = awsVaultConfiguration.getAccessKey();
            secretKey = awsVaultConfiguration.getSecretKey();
            region = awsVaultConfiguration.getRegion();
            useDefaultCredentialsProvider = awsVaultConfiguration.isDefaultCredentialsProvider();
        }
        if (ObjectHelper.isNotEmpty((Object)accessKey) && ObjectHelper.isNotEmpty((Object)secretKey) && ObjectHelper.isNotEmpty((Object)region)) {
            clientBuilder = SecretsManagerClient.builder();
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
            clientBuilder = (SecretsManagerClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
            clientBuilder.region(Region.of((String)region));
            this.client = (SecretsManagerClient)clientBuilder.build();
        } else if (useDefaultCredentialsProvider && ObjectHelper.isNotEmpty((Object)region)) {
            clientBuilder = SecretsManagerClient.builder();
            clientBuilder.region(Region.of((String)region));
            this.client = (SecretsManagerClient)clientBuilder.build();
        } else {
            throw new RuntimeCamelException("Using the AWS Secrets Manager Properties Function requires setting AWS credentials as application properties or environment variables");
        }
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        super.doStop();
    }

    public String getName() {
        return "aws";
    }

    public String apply(String remainder) {
        String key = remainder;
        String subkey = null;
        String returnValue = null;
        String defaultValue = null;
        if (remainder.contains("/")) {
            key = StringHelper.before((String)remainder, (String)"/");
            subkey = StringHelper.after((String)remainder, (String)"/");
            defaultValue = StringHelper.after((String)subkey, (String)":");
            if (subkey.contains(":")) {
                subkey = StringHelper.before((String)subkey, (String)":");
            }
        } else if (remainder.contains(":")) {
            key = StringHelper.before((String)remainder, (String)":");
            defaultValue = StringHelper.after((String)remainder, (String)":");
        }
        if (key != null) {
            try {
                returnValue = this.getSecretFromSource(key, subkey, defaultValue);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeCamelException("Something went wrong while recovering " + key + " from vault");
            }
        }
        return returnValue;
    }

    private String getSecretFromSource(String key, String subkey, String defaultValue) throws JsonProcessingException {
        String returnValue;
        GetSecretValueRequest.Builder builder = GetSecretValueRequest.builder();
        builder.secretId(key);
        GetSecretValueRequest request = (GetSecretValueRequest)builder.build();
        try {
            GetSecretValueResponse secret = this.client.getSecretValue(request);
            returnValue = ObjectHelper.isNotEmpty((Object)secret.secretString()) ? secret.secretString() : new String(Base64.getDecoder().decode(secret.secretBinary().asByteBuffer()).array());
            if (ObjectHelper.isNotEmpty((Object)subkey)) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode actualObj = mapper.readTree(returnValue);
                JsonNode field = actualObj.get(subkey);
                returnValue = ObjectHelper.isNotEmpty((Object)field) ? field.textValue() : null;
            }
            if (ObjectHelper.isEmpty((Object)returnValue)) {
                returnValue = defaultValue;
            }
        }
        catch (SecretsManagerException ex) {
            if (ObjectHelper.isNotEmpty((Object)defaultValue)) {
                returnValue = defaultValue;
            }
            throw ex;
        }
        return returnValue;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

